/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.block.base.tile.TileEntityAdvancedMachine;
import ic2.core.block.base.util.output.MultiSlotOutput;
import ic2.core.block.machine.low.TileEntityCompressor;
import ic2.core.block.machine.low.TileEntityPump;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.slots.SlotCustom;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.inventory.slots.SlotOutput;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntitySingularityCompressor
extends TileEntityAdvancedMachine {
    public TileEntityPump[] connectingPumps = new TileEntityPump[6];
    public IMachineRecipeList.RecipeEntry entry;

    public TileEntitySingularityCompressor() {
        super(3, 15, 4000);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.compressor;
    }

    @Override
    public MachineType getType() {
        return MachineType.compressed;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.CompressorGui.class;
    }

    @Override
    public LocaleComp getSpeedName() {
        return Ic2GuiLang.machinePressure;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.singularityCompressor;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.singularityCompressor;
    }

    public IMachineRecipeList.RecipeEntry getEntry() {
        if (this.entry == null) {
            this.entry = new IMachineRecipeList.RecipeEntry(new CompressorRecipeInput(this), new TileEntityCompressor.SnowballOutput(), "Snow");
        }
        return this.entry;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        IMachineRecipeList.RecipeEntry entry;
        IMachineRecipeList.RecipeEntry recipeEntry = entry = input.func_190926_b() ? null : ClassicRecipes.compressor.getRecipeInAndOutput(input, false);
        if (entry == null && this.getValidPump() != null) {
            return this.getEntry();
        }
        return entry;
    }

    @Override
    public void operateOnce(int slot, IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        if (output instanceof TileEntityCompressor.SnowballOutput) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.getFluidBelow(true);
            pump.usePump();
            for (ItemStack stack : output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData())) {
                list.add(new MultiSlotOutput(stack, this.getOutputSlots()));
            }
            return;
        }
        super.operateOnce(slot, input, output, list);
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2};
    }

    @Override
    public Slot[] getInventorySlots(InventoryPlayer player) {
        Slot[] slots = new Slot[]{new SlotDischarge(this, Integer.MAX_VALUE, 0, 56, 53), new SlotCustom(this, 1, 56, 17, new MachineFilter(this)), new SlotOutput(player.field_70458_d, this, 2, 116, 35)};
        return slots;
    }

    @Override
    public ResourceLocation getProcessSoundFile() {
        return Ic2Sounds.compressorOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (this.getRecipeCheck(par1) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    public IMachineRecipeList.RecipeEntry getRecipeCheck(ItemStack input) {
        IMachineRecipeList.RecipeEntry entry;
        IMachineRecipeList.RecipeEntry recipeEntry = entry = input.func_190926_b() ? null : ClassicRecipes.compressor.getRecipeInAndOutput(input, true);
        if (entry == null && this.getValidPump() != null) {
            return this.getEntry();
        }
        return entry;
    }

    public TileEntityPump getValidPump() {
        for (Direction dir : Direction.directions) {
            TileEntityPump pump = this.connectingPumps[dir.toSideValue()];
            if (pump == null) continue;
            if (pump.func_145837_r()) {
                this.connectingPumps[dir.toSideValue()] = null;
                continue;
            }
            if (!pump.isPumpReady() || !pump.isFluidBelow(FluidRegistry.WATER)) continue;
            return pump;
        }
        return null;
    }

    private void updatePumps() {
        for (Direction dir : Direction.directions) {
            TileEntity tile = dir.applyToTileEntity(this);
            this.connectingPumps[dir.toSideValue()] = tile == null || !(tile instanceof TileEntityPump) ? null : (TileEntityPump)tile;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.updatePumps();
        }
        super.func_73660_a();
    }

    public static class CompressorRecipeInput
    implements INullableRecipeInput {
        IRecipeInput input = new RecipeInputFluid(FluidRegistry.WATER);
        TileEntitySingularityCompressor comp;

        public CompressorRecipeInput(TileEntitySingularityCompressor recipe) {
            this.comp = recipe;
        }

        @Override
        public boolean matches(ItemStack subject) {
            return subject.func_190926_b() && this.comp.getValidPump() != null;
        }

        @Override
        public int getAmount() {
            return 0;
        }

        @Override
        public List<ItemStack> getInputs() {
            return this.input.getInputs();
        }
    }
}

