/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.AppliedEnergistics;
import assets.recipehandler.ChangePacket;
import assets.recipehandler.CraftingHandler;
import assets.recipehandler.EnderIO;
import assets.recipehandler.FurnaceHandler;
import assets.recipehandler.PacketHandler;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class Proxy {
    public FMLEventChannel network;
    public CraftingHandler craftingHandler = new CraftingHandler();
    public FurnaceHandler furnaceHandler;

    public void setup(Configuration config) {
        this.network = NetworkRegistry.INSTANCE.newEventDrivenChannel("recipemod:key");
        this.network.register((Object)new PacketHandler());
        if (config.getBoolean("Enable Custom Crafting Detection", "general", true, "Tries to detect other crafting systems, disable for less processing")) {
            this.craftingHandler.enableGuessing(Arrays.asList(config.getStringList("Black List Crafting Container", "general", new String[]{"net.blay09.mods.cookingforblockheads.container.ContainerRecipeBook", "morph.avaritia.container.ContainerExtremeCrafting", "slimeknights.tconstruct.tools.common.inventory.ContainerPartBuilder", "slimeknights.tconstruct.tools.common.inventory.ContainerStencilTable", "jds.bibliocraft.containers.ContainerDiscRack"}, "List of containers to ignore for custom crafting detection")));
        }
        this.furnaceHandler = new FurnaceHandler(config.getBoolean("Enable Furnace Recipes Tracking", "general", false, "Tracks furnace recipes changes from the mod starting point"));
    }

    public void register() {
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.craftingHandler.addCompatibility(new AppliedEnergistics("ContainerCraftingTerm"));
            this.craftingHandler.addCompatibility(new AppliedEnergistics("ContainerPatternTerm"));
        }
        if (Loader.isModLoaded((String)"enderiomachines")) {
            this.craftingHandler.addCompatibility(new EnderIO("$Simple"));
            this.craftingHandler.addCompatibility(new EnderIO("$Normal"));
        }
    }

    public void scheduleTask(ChangePacket runner) {
    }

    public void sendShift(InventoryCrafting crafting, Slot result) {
    }

    @Nullable
    public ChangePacket getAnswer(EntityPlayerMP player, ChangePacket packet) {
        InventoryCrafting crafting = this.craftingHandler.getCraftingMatrix(player.field_71070_bA);
        if (crafting != null) {
            Slot result;
            ItemStack itr;
            this.craftingHandler.setRecipeIndex(packet.index());
            IRecipe recipe = this.craftingHandler.findMatchingRecipe(crafting, player.func_130014_f_());
            if (recipe != null && ItemStack.func_179545_c((ItemStack)(itr = recipe.func_77572_b(crafting)), (ItemStack)packet.stack()) && itr.func_190916_E() == packet.stack().func_190916_E() && this.compareNBT(itr, packet.stack()) && (result = this.craftingHandler.getResultSlot(player.field_71070_bA, crafting, packet.slot())) != null && this.craftingHandler.setCraftUsed(player, recipe)) {
                result.func_75215_d(packet.stack().func_77946_l());
                return new ChangePacket(packet);
            }
        }
        return null;
    }

    private boolean compareNBT(ItemStack stackA, ItemStack stackB) {
        NBTTagCompound shareTagA = stackA.func_77973_b().getNBTShareTag(stackA);
        NBTTagCompound shareTagB = stackB.func_77973_b().getNBTShareTag(stackB);
        if (shareTagA == null || !this.hasData(shareTagA)) {
            return shareTagB == null || !this.hasData(shareTagB);
        }
        return shareTagA.equals((Object)shareTagB);
    }

    private boolean hasData(NBTTagCompound tag) {
        if (!tag.func_82582_d()) {
            for (String key : tag.func_150296_c()) {
                NBTBase nbt = tag.func_74781_a(key);
                if (nbt == null || nbt.func_82582_d()) continue;
                return true;
            }
        }
        return false;
    }
}

