/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scheduler;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CraftTask
implements BukkitTask,
Runnable {
    private volatile CraftTask next = null;
    public static final int ERROR = 0;
    public static final int NO_REPEATING = -1;
    public static final int CANCEL = -2;
    public static final int PROCESS_FOR_FUTURE = -3;
    public static final int DONE_FOR_FUTURE = -4;
    private volatile long period;
    private long nextRun;
    public final Runnable task;
    public Timing timings;
    private final Plugin plugin;
    private final int id;

    CraftTask() {
        this(null, null, -1, -1L);
    }

    CraftTask(Runnable task) {
        this(null, task, -1, -1L);
    }

    CraftTask(Plugin plugin, Runnable task, int id, long period) {
        this.plugin = plugin;
        this.task = task;
        this.id = id;
        this.period = period;
        this.timings = task != null ? MinecraftTimings.getPluginTaskTimings(this, period) : null;
    }

    @Override
    public final int getTaskId() {
        return this.id;
    }

    @Override
    public final Plugin getOwner() {
        return this.plugin;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public void run() {
        if (this.timings != null && this.isSync()) {
            this.timings.startTiming();
        }
        this.task.run();
        if (this.timings != null && this.isSync()) {
            this.timings.stopTiming();
        }
    }

    long getPeriod() {
        return this.period;
    }

    void setPeriod(long period) {
        this.period = period;
    }

    long getNextRun() {
        return this.nextRun;
    }

    void setNextRun(long nextRun) {
        this.nextRun = nextRun;
    }

    CraftTask getNext() {
        return this.next;
    }

    void setNext(CraftTask next) {
        this.next = next;
    }

    Class<? extends Runnable> getTaskClass() {
        return this.task.getClass();
    }

    @Override
    public boolean isCancelled() {
        return this.period == -2L;
    }

    @Override
    public void cancel() {
        Bukkit.getScheduler().cancelTask(this.id);
    }

    boolean cancel0() {
        this.setPeriod(-2L);
        return true;
    }
}

