/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.console.log4j;

import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.util.ANSIColorUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="highlightMsg", category="Converter")
@ConverterKeys(value={"highlightMsg"})
@PerformanceSensitive(value={"allocation"})
public class HighlightMsgConverter
extends LogEventPatternConverter {
    private static final String ANSI_RESET = "\u001b[39;0m";
    private static final String ANSI_ERROR = HighlightMsgConverter.getError();
    private static final String ANSI_WARN = HighlightMsgConverter.getWarn();
    private static final String ANSI_INFO = HighlightMsgConverter.getInfo();
    private static final String ANSI_FATAL = HighlightMsgConverter.getFatal();
    private static final String ANSI_TRACE = HighlightMsgConverter.getTrace();
    private final List<PatternFormatter> formatters;

    protected HighlightMsgConverter(List<PatternFormatter> formatters) {
        super("highlightMsg", null);
        this.formatters = formatters;
    }

    @Nullable
    public static HighlightMsgConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on highlightMsg. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on highlightMsg");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        return new HighlightMsgConverter(formatters);
    }

    public static String getError() {
        String cc = MohistConfig.getHighlight("consolecolor.error-msg", "c");
        return ANSIColorUtils.getColor(cc, "\u001b[31;1m");
    }

    public static String getWarn() {
        String cc = MohistConfig.getHighlight("consolecolor.warn-msg", "e");
        return ANSIColorUtils.getColor(cc, "\u001b[33;1m");
    }

    public static String getInfo() {
        String cc = MohistConfig.getHighlight("consolecolor.info-msg", "r");
        return ANSIColorUtils.getColor(cc, ANSI_RESET);
    }

    public static String getFatal() {
        String cc = MohistConfig.getHighlight("consolecolor.fatal-msg", "e");
        return ANSIColorUtils.getColor(cc, "\u001b[31;1m");
    }

    public static String getTrace() {
        String cc = MohistConfig.getHighlight("consolecolor.trace-msg", "e");
        return ANSIColorUtils.getColor(cc, "\u001b[31;1m");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        Level level = event.getLevel();
        if (level.isMoreSpecificThan(Level.ERROR)) {
            this.format(ANSI_ERROR, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            this.format(ANSI_WARN, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            this.format(ANSI_INFO, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.FATAL)) {
            this.format(ANSI_FATAL, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.TRACE)) {
            this.format(ANSI_TRACE, event, toAppendTo);
            return;
        }
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
    }

    private void format(String style, LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        toAppendTo.append(style);
        int end = toAppendTo.length();
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
        if (toAppendTo.length() == end) {
            toAppendTo.setLength(start);
        } else {
            toAppendTo.append(ANSI_RESET);
        }
    }

    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }
}

