/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.event.profile.LookupProfileEvent;
import com.destroystokyo.paper.event.profile.PreLookupProfileEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.Sets;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import java.util.HashSet;
import java.util.Set;

public class PaperGameProfileRepository
extends YggdrasilGameProfileRepository {
    public PaperGameProfileRepository(YggdrasilAuthenticationService authenticationService) {
        super(authenticationService);
    }

    public void findProfilesByNames(String[] names, Agent agent, ProfileLookupCallback callback) {
        HashSet unfoundNames = Sets.newHashSet();
        for (String name : names) {
            PreLookupProfileEvent event = new PreLookupProfileEvent(name);
            event.callEvent();
            if (event.getUUID() != null) {
                GameProfile gameprofile = new GameProfile(event.getUUID(), name);
                Set<ProfileProperty> profileProperties = event.getProfileProperties();
                if (!profileProperties.isEmpty()) {
                    for (ProfileProperty property : profileProperties) {
                        gameprofile.getProperties().put((Object)property.getName(), (Object)CraftPlayerProfile.asAuthlib(property));
                    }
                }
                callback.onProfileLookupSucceeded(gameprofile);
                continue;
            }
            unfoundNames.add(name);
        }
        if (!unfoundNames.isEmpty()) {
            String[] namesArr = unfoundNames.toArray(new String[unfoundNames.size()]);
            super.findProfilesByNames(namesArr, agent, (ProfileLookupCallback)new PreProfileLookupCallback(callback));
        }
    }

    private static class PreProfileLookupCallback
    implements ProfileLookupCallback {
        private final ProfileLookupCallback callback;

        PreProfileLookupCallback(ProfileLookupCallback callback) {
            this.callback = callback;
        }

        public void onProfileLookupSucceeded(GameProfile gameProfile) {
            PlayerProfile from = CraftPlayerProfile.asBukkitMirror(gameProfile);
            new LookupProfileEvent(from).callEvent();
            this.callback.onProfileLookupSucceeded(gameProfile);
        }

        public void onProfileLookupFailed(GameProfile gameProfile, Exception e) {
            this.callback.onProfileLookupFailed(gameProfile, e);
        }
    }
}

