/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.internal.gson.JsonElement;
import com.sk89q.worldedit.internal.gson.JsonObject;
import com.sk89q.worldedit.internal.gson.JsonParser;
import com.sk89q.worldedit.internal.gson.JsonPrimitive;
import com.sk89q.worldedit.internal.gson.JsonSyntaxException;
import java.util.Map;

public class SignCompatibilityHandler
implements NBTCompatibilityHandler {
    @Override
    public boolean isAffectedBlock(BaseBlock block) {
        return block.getType() == 63 || block.getType() == 68;
    }

    @Override
    public void updateNBT(BaseBlock block, Map<String, Tag> values) {
        for (int i = 0; i < 4; ++i) {
            String key = "Text" + (i + 1);
            Tag value = values.get(key);
            if (!(value instanceof StringTag)) continue;
            String storedString = ((StringTag)value).getValue();
            JsonElement jsonElement = null;
            if (storedString != null && storedString.startsWith("{")) {
                try {
                    jsonElement = new JsonParser().parse(storedString);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            if (jsonElement == null) {
                jsonElement = new JsonPrimitive(storedString == null ? "" : storedString);
            }
            if (jsonElement.isJsonObject()) continue;
            if (jsonElement.isJsonNull()) {
                jsonElement = new JsonPrimitive("");
            }
            JsonObject jsonTextObject = new JsonObject();
            jsonTextObject.add("text", jsonElement);
            values.put("Text" + (i + 1), new StringTag(jsonTextObject.toString()));
        }
    }
}

