/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.lang.reflect.Field;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.Recipes;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class TechRebornIntegration
extends AbstractIntegrationThread {
    private Field recipeOutputs;

    TechRebornIntegration() {
        super("TechReborn");
        try {
            this.recipeOutputs = Recipe.class.getDeclaredField("itemOutputs");
            this.recipeOutputs.setAccessible(true);
        }
        catch (NoSuchFieldException | NullPointerException e) {
            this.logger.error("Couldn't find TechReborn fields!");
            e.printStackTrace();
        }
    }

    public String call() {
        try {
            this.fixFusionReactorRecipe();
            this.fixTechRebornRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "now Tech is truly Reborn.";
    }

    private void fixTechRebornRecipes() {
        reborncore.api.recipe.RecipeHandler.recipeList.forEach(recipe -> {
            if (!recipe.useOreDic()) {
                this.resourceHandler.setMainObjects(recipe.getInputs());
            }
            this.resourceHandler.setMainItemStacks(recipe.getOutputs());
        });
        if (this.recipeOutputs == null) {
            return;
        }
        this.fixPraescriptumRecipes(Recipes.alloySmelter);
        this.fixPraescriptumRecipes(Recipes.assemblingMachine);
        this.fixPraescriptumRecipes(Recipes.centrifuge);
        this.fixPraescriptumRecipes(Recipes.chemicalReactor);
        this.fixPraescriptumRecipes(Recipes.compressor);
        this.fixPraescriptumRecipes(Recipes.extractor);
        this.fixPraescriptumRecipes(Recipes.grinder);
        this.fixPraescriptumRecipes(Recipes.plateBendingMachine);
        this.fixPraescriptumRecipes(Recipes.recycler);
        this.fixPraescriptumRecipes(Recipes.solidCanningMachine);
        this.fixPraescriptumRecipes(Recipes.wireMill);
    }

    private void fixPraescriptumRecipes(RecipeHandler handler) {
        if (handler == null) {
            return;
        }
        handler.getRecipes().forEach(recipe -> {
            try {
                this.recipeOutputs.set(recipe, this.resourceHandler.getMainItemStacks(recipe.getItemOutputs()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private void fixFusionReactorRecipe() {
        FusionReactorRecipeHelper.reactorRecipes.forEach(fusionReactorRecipe -> Util.setField(FusionReactorRecipe.class, (String)"output", (Object)fusionReactorRecipe, (Object)this.resourceHandler.getMainItemStack(fusionReactorRecipe.getOutput())));
    }
}

