/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.annotation.LateMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"slimeknights/tconstruct/library/client/model/BakedToolModel$ToolItemOverrideList"})
@ClientOnlyMixin
@LateMixin
public class BakedToolModelListMixin {
    @Shadow
    private Cache<?, IBakedModel> bakedModelCache;
    private LoadingCache<IBakedModel, Cache<Object, IBakedModel>> parentToRealCache = CacheBuilder.newBuilder().maximumSize(70L).expireAfterWrite(3L, TimeUnit.MINUTES).weakKeys().softValues().build((CacheLoader)new CacheLoader<IBakedModel, Cache<Object, IBakedModel>>(){

        public Cache<Object, IBakedModel> load(IBakedModel key) throws Exception {
            return CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(50L).build();
        }
    });
    private static final MethodHandle parentModelGetter;

    private IBakedModel cacheKeyToModel(Object key, Callable<? extends IBakedModel> loader) throws ExecutionException {
        IBakedModel parent;
        try {
            parent = parentModelGetter.invoke(key);
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
        Cache realCache = (Cache)this.parentToRealCache.get((Object)parent);
        return (IBakedModel)realCache.get(key, loader);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void useSoftCache(CallbackInfo ci) {
        this.bakedModelCache = new Cache<Object, IBakedModel>(){

            @Nullable
            public IBakedModel getIfPresent(Object key) {
                throw new UnsupportedOperationException();
            }

            public IBakedModel get(Object key, Callable<? extends IBakedModel> loader) throws ExecutionException {
                return BakedToolModelListMixin.this.cacheKeyToModel(key, loader);
            }

            public ImmutableMap<Object, IBakedModel> getAllPresent(Iterable<?> keys) {
                throw new UnsupportedOperationException();
            }

            public void put(Object key, IBakedModel value) {
                throw new UnsupportedOperationException();
            }

            public void putAll(Map<?, ? extends IBakedModel> m) {
                throw new UnsupportedOperationException();
            }

            public void invalidate(Object key) {
                throw new UnsupportedOperationException();
            }

            public void invalidateAll(Iterable<?> keys) {
                throw new UnsupportedOperationException();
            }

            public void invalidateAll() {
                throw new UnsupportedOperationException();
            }

            public long size() {
                throw new UnsupportedOperationException();
            }

            public CacheStats stats() {
                throw new UnsupportedOperationException();
            }

            public ConcurrentMap<Object, IBakedModel> asMap() {
                throw new UnsupportedOperationException();
            }

            public void cleanUp() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        MethodHandle m;
        try {
            Class<?> cacheKey = Class.forName("slimeknights.tconstruct.library.client.model.BakedToolModel$CacheKey");
            Field parentField = ObfuscationReflectionHelper.findField(cacheKey, (String)"parent");
            parentField.setAccessible(true);
            m = MethodHandles.lookup().unreflectGetter(parentField);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        parentModelGetter = m;
    }
}

