/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.destination;

import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class RandomPortalDestination
implements MVDestination {
    private static final Random RANDOM = new Random();
    private List<MVPortal> portals;
    private Core core;

    public String getIdentifier() {
        return "rp";
    }

    public boolean isThisType(JavaPlugin plugin, String dest) {
        this.core = (Core)plugin.getServer().getPluginManager().getPlugin("Multiverse-Core");
        return dest.startsWith("rp:");
    }

    public Location getLocation(Entity e) {
        MVPortal portal = this.portals.get(RANDOM.nextInt(this.portals.size()));
        PortalLocation pl = portal.getLocation();
        double portalWidth = Math.abs(pl.getMaximum().getBlockX() - pl.getMinimum().getBlockX()) + 1;
        double portalDepth = Math.abs(pl.getMaximum().getBlockZ() - pl.getMinimum().getBlockZ()) + 1;
        double finalX = portalWidth / 2.0 + (double)pl.getMinimum().getBlockX();
        double finalZ = portalDepth / 2.0 + (double)pl.getMinimum().getBlockZ();
        double finalY = this.getMinimumWith2Air((int)finalX, (int)finalZ, pl.getMinimum().getBlockY(), pl.getMaximum().getBlockY(), portal.getWorld());
        return new Location(portal.getWorld(), finalX, finalY, finalZ);
    }

    private double getMinimumWith2Air(int finalX, int finalZ, int y, int yMax, World w) {
        for (int i = y; i < yMax; ++i) {
            if (!this.core.getBlockSafety().playerCanSpawnHereSafely(w, (double)finalX, (double)i, (double)finalZ)) continue;
            return i;
        }
        return y;
    }

    public boolean isValid() {
        return !this.portals.isEmpty();
    }

    public void setDestination(JavaPlugin plugin, String dest) {
        this.portals = new ArrayList<MVPortal>();
        MultiversePortals portalPlugin = (MultiversePortals)plugin.getServer().getPluginManager().getPlugin("Multiverse-Portals");
        String[] split = dest.split(":");
        for (int i = 1; i < split.length; ++i) {
            MVPortal portal = portalPlugin.getPortalManager().getPortal(split[i]);
            if (portal == null) continue;
            this.portals.add(portal);
        }
    }

    public String getType() {
        return "Portal";
    }

    public String getName() {
        return "Random portal!";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getIdentifier());
        for (MVPortal portal : this.portals) {
            builder.append(':').append(portal.getName());
        }
        return builder.toString();
    }

    public String getRequiredPermission() {
        return "multiverse.portal.random";
    }

    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    public boolean useSafeTeleporter() {
        return true;
    }
}

