/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.destination;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.utils.BlockSafety;
import com.onarandombox.MultiverseCore.utils.LocationManipulation;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalLocation;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class PortalDestination
implements MVDestination {
    private MVPortal portal;
    private boolean isValid;
    private String orientationString;

    public String getIdentifier() {
        return "p";
    }

    public boolean isThisType(JavaPlugin plugin, String dest) {
        MultiversePortals portalPlugin = (MultiversePortals)plugin.getServer().getPluginManager().getPlugin("Multiverse-Portals");
        String[] split = dest.split(":");
        if (split.length > 3 || split.length < 2) {
            return false;
        }
        return split[0].equalsIgnoreCase("p") && portalPlugin.getPortalManager().isPortal(split[1]);
    }

    public Location getLocation(Entity e) {
        PortalLocation pl = this.portal.getLocation();
        double portalWidth = Math.abs(pl.getMaximum().getBlockX() - pl.getMinimum().getBlockX()) + 1;
        double portalDepth = Math.abs(pl.getMaximum().getBlockZ() - pl.getMinimum().getBlockZ()) + 1;
        double finalX = portalWidth / 2.0 + (double)pl.getMinimum().getBlockX();
        double finalZ = portalDepth / 2.0 + (double)pl.getMinimum().getBlockZ();
        double finalY = this.getMinimumWith2Air((int)finalX, (int)finalZ, pl.getMinimum().getBlockY(), pl.getMaximum().getBlockY(), this.portal.getWorld());
        return new Location(this.portal.getWorld(), finalX, finalY, finalZ, LocationManipulation.getYaw((String)this.orientationString), 0.0f);
    }

    private double getMinimumWith2Air(int finalX, int finalZ, int y, int yMax, World w) {
        BlockSafety bs = new BlockSafety();
        for (int i = y; i < yMax; ++i) {
            if (!bs.playerCanSpawnHereSafely(w, (double)finalX, (double)i, (double)finalZ)) continue;
            return i;
        }
        return y;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setDestination(JavaPlugin plugin, String dest) {
        MultiversePortals portalPlugin = (MultiversePortals)plugin.getServer().getPluginManager().getPlugin("Multiverse-Portals");
        String[] split = dest.split(":");
        if (split.length > 3) {
            this.isValid = false;
            return;
        }
        if (split.length >= 2 && split[0].equalsIgnoreCase("p")) {
            if (!portalPlugin.getPortalManager().isPortal(split[1])) {
                this.isValid = false;
                return;
            }
            this.isValid = true;
            this.portal = portalPlugin.getPortalManager().getPortal(split[1]);
            if (split.length == 3) {
                this.orientationString = split[2];
            }
        }
    }

    public String getType() {
        return "Portal";
    }

    public String getName() {
        return this.portal.getName();
    }

    public String toString() {
        if (this.orientationString != null && this.orientationString.length() > 0) {
            return "p:" + this.portal.getName() + ":" + this.orientationString;
        }
        return "p:" + this.portal.getName();
    }

    public String getOrientationString() {
        return this.orientationString;
    }

    public String getRequiredPermission() {
        return "multiverse.portal.access." + this.portal.getName();
    }

    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    public boolean useSafeTeleporter() {
        return this.portal.useSafeTeleporter();
    }
}

