/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals;

import com.sk89q.worldedit.bukkit.WorldEditAPI;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldEditConnection {
    private final Plugin connectingPlugin;
    private WorldEditPlugin worldEditPlugin;
    WorldEditAPI worldEditAPI;

    WorldEditConnection(Plugin plugin) {
        if (plugin == null) {
            throw new RuntimeException("plugin must not be null.");
        }
        this.connectingPlugin = plugin;
    }

    private WorldEditPlugin retrieveWorldEditPluginFromServer() {
        Plugin plugin = this.connectingPlugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (plugin == null) {
            return null;
        }
        if (plugin instanceof WorldEditPlugin) {
            return (WorldEditPlugin)plugin;
        }
        this.connectingPlugin.getLogger().warning("WorldEdit v" + plugin.getDescription().getVersion() + " is incompatible with " + this.connectingPlugin.getDescription().getName() + " v" + this.connectingPlugin.getDescription().getVersion());
        return null;
    }

    boolean connect() {
        if (!this.isConnected()) {
            this.worldEditPlugin = this.retrieveWorldEditPluginFromServer();
            if (this.worldEditPlugin != null) {
                this.worldEditAPI = new WorldEditAPI(this.worldEditPlugin);
                this.connectingPlugin.getLogger().info("Found WorldEdit. Using it for selections.");
                return true;
            }
        }
        return false;
    }

    void disconnect() {
        this.worldEditPlugin = null;
        this.worldEditAPI = null;
    }

    public boolean isConnected() {
        return this.worldEditPlugin != null;
    }

    private Selection getSelection(Player player) {
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        return this.worldEditPlugin.getSelection(player);
    }

    public Location getSelectionMaxPoint(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        Selection selection = this.getSelection(player);
        return selection != null ? selection.getMaximumPoint() : null;
    }

    public Location getSelectionMinPoint(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        Selection selection = this.getSelection(player);
        return selection != null ? selection.getMinimumPoint() : null;
    }

    public boolean isSelectionAvailable(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        return this.getSelection(player) != null;
    }
}

