/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.utils.MultiverseRegion;
import com.sk89q.worldedit.Vector;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class PortalLocation {
    private MultiverseRegion region;
    private boolean validLocation = false;

    public PortalLocation(org.bukkit.util.Vector pos1, org.bukkit.util.Vector pos2, MultiverseWorld world) {
        this.validLocation = this.setLocation(pos1, pos2, world);
    }

    public PortalLocation() {
    }

    public PortalLocation(Vector minPt, Vector maxPt, MultiverseWorld world) {
        this(new org.bukkit.util.Vector(minPt.getX(), minPt.getY(), minPt.getZ()), new org.bukkit.util.Vector(maxPt.getX(), maxPt.getY(), maxPt.getZ()), world);
    }

    public static PortalLocation parseLocation(String locationString, MultiverseWorld world, String portalName) {
        String[] split = locationString.split(":");
        if (split.length != 2) {
            MultiversePortals.staticLog(Level.WARNING, "Failed Parsing Location for: " + portalName + " (Format Error, was expecting: `X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)");
            return PortalLocation.getInvalidPortalLocation();
        }
        if (world == null) {
            MultiversePortals.staticLog(Level.WARNING, "Failed Parsing World for: " + portalName + " (World Error, World did not exist or was not imported into Multiverse-Core!)");
            return PortalLocation.getInvalidPortalLocation();
        }
        org.bukkit.util.Vector pos1 = PortalLocation.parseVector(split[0]);
        org.bukkit.util.Vector pos2 = PortalLocation.parseVector(split[1]);
        if (pos1 == null || pos2 == null) {
            MultiversePortals.staticLog(Level.WARNING, "Failed Parsing Location for: " + portalName + " (Vector Error, was expecting: `X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)");
            return PortalLocation.getInvalidPortalLocation();
        }
        return new PortalLocation(pos1, pos2, world);
    }

    private static PortalLocation getInvalidPortalLocation() {
        return new PortalLocation();
    }

    private static org.bukkit.util.Vector parseVector(String vectorString) {
        String[] stringCoords = vectorString.split(",");
        double[] coords = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                coords[i] = Double.parseDouble(stringCoords[i]);
                continue;
            }
            catch (NumberFormatException e) {
                coords[i] = 0.0;
                return null;
            }
        }
        return new org.bukkit.util.Vector(coords[0], coords[1], coords[2]);
    }

    public boolean setLocation(org.bukkit.util.Vector v1, org.bukkit.util.Vector v2, MultiverseWorld world) {
        if (v1 == null || v2 == null || world == null) {
            this.validLocation = false;
            this.region = null;
        } else {
            this.validLocation = true;
            this.region = new MultiverseRegion(v1, v2, world);
        }
        return this.validLocation;
    }

    public boolean setLocation(String v1, String v2, MultiverseWorld world) {
        if (v1 == null || v2 == null) {
            this.validLocation = false;
            this.region = null;
            return false;
        }
        return this.setLocation(PortalLocation.parseVector(v1), PortalLocation.parseVector(v2), world);
    }

    public boolean isValidLocation() {
        return this.validLocation;
    }

    public List<org.bukkit.util.Vector> getVectors() {
        return Arrays.asList(this.region.getMinimumPoint(), this.region.getMaximumPoint());
    }

    public org.bukkit.util.Vector getMinimum() {
        return this.region.getMinimumPoint();
    }

    public org.bukkit.util.Vector getMaximum() {
        return this.region.getMaximumPoint();
    }

    public String toString() {
        if (this.region == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.region.getMinimumPoint().getX() + ",");
        sb.append(this.region.getMinimumPoint().getY() + ",");
        sb.append(this.region.getMinimumPoint().getZ() + ":");
        sb.append(this.region.getMaximumPoint().getX() + ",");
        sb.append(this.region.getMaximumPoint().getY() + ",");
        sb.append(this.region.getMaximumPoint().getZ());
        return sb.toString();
    }

    public MultiverseWorld getMVWorld() {
        if (this.region == null) {
            return null;
        }
        return this.region.getWorld();
    }

    public MultiverseRegion getRegion() {
        return this.region;
    }
}

