/*
 * Decompiled with CFR 0.152.
 */
package io.dogboy.serializationisbad.core;

import com.google.gson.Gson;
import io.dogboy.serializationisbad.core.config.SIBConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SerializationIsBad {
    public static final Logger logger = LogManager.getLogger(SerializationIsBad.class);
    private static SerializationIsBad instance;
    private static boolean agentActive;
    private static final String remoteConfigUrl = "https://raw.githubusercontent.com/dogboy21/serializationisbad/master/serializationisbad.json";
    private final SIBConfig config;

    public static SerializationIsBad getInstance() {
        return instance;
    }

    public static void init(File minecraftDir) {
        if (instance != null) {
            logger.warn("Attempted to initialize SerializationIsBad twice, skipping");
            return;
        }
        String implementationType = SerializationIsBad.getImplementationType();
        if (implementationType.equals("agent")) {
            agentActive = true;
        }
        logger.info("Initializing SerializationIsBad, implementation type: " + implementationType);
        instance = new SerializationIsBad(minecraftDir);
    }

    private SerializationIsBad(File minecraftDir) {
        this.config = SerializationIsBad.readConfig(minecraftDir);
        logger.info("Loaded config file");
        logger.info("  Blocking Enabled: " + this.config.isExecuteBlocking());
        logger.info("  Loaded Patch Modules: " + this.config.getPatchModules().size());
    }

    public SIBConfig getConfig() {
        return this.config;
    }

    private static SIBConfig readConfig(File minecraftDir) {
        File configFile = new File(new File(minecraftDir, "config"), "serializationisbad.json");
        SIBConfig remoteConfig = SerializationIsBad.readRemoteConfig();
        if (remoteConfig != null) {
            logger.info("Using remote config file");
            return remoteConfig;
        }
        if (configFile.isFile()) {
            SIBConfig sIBConfig;
            Gson gson = new Gson();
            FileInputStream fileInputStream = new FileInputStream(configFile);
            try {
                sIBConfig = (SIBConfig)gson.fromJson((Reader)new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8), SIBConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Failed to load config file", (Throwable)e);
                }
            }
            fileInputStream.close();
            return sIBConfig;
        }
        throw new RuntimeException("You are currently using SerializationIsBad without a config file. The mod on its own doesn't do anything so please install a config file patching the vulnerabilities to " + configFile);
    }

    private static SIBConfig readRemoteConfig() {
        SIBConfig sIBConfig;
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(new URL(remoteConfigUrl).openStream(), StandardCharsets.UTF_8);
        try {
            sIBConfig = (SIBConfig)gson.fromJson((Reader)inputStreamReader, SIBConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Failed to load remote config file", (Throwable)e);
                return null;
            }
        }
        inputStreamReader.close();
        return sIBConfig;
    }

    private static String getImplementationType() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("io.dogboy.serializationisbad.") || stackTraceElement.getClassName().startsWith("io.dogboy.serializationisbad.core.")) continue;
            return stackTraceElement.getClassName().split("[.]")[3];
        }
        return "unknown";
    }

    public static boolean isAgentActive() {
        return agentActive;
    }

    static {
        agentActive = false;
    }
}

