/*
 * Decompiled with CFR 0.152.
 */
package io.dogboy.serializationisbad.core;

import io.dogboy.serializationisbad.core.SerializationIsBad;
import io.dogboy.serializationisbad.core.config.PatchModule;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Patches {
    public static PatchModule getPatchModuleForClass(String className) {
        for (PatchModule patchModule : SerializationIsBad.getInstance().getConfig().getPatchModules()) {
            if (!patchModule.getClassesToPatch().contains(className)) continue;
            return patchModule;
        }
        return null;
    }

    public static ClassNode readClassNode(byte[] classBytecode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytecode);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] writeClassNode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void applyPatches(String className, ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            InsnList instructions = methodNode.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                AbstractInsnNode instruction = instructions.get(i);
                if (instruction.getOpcode() == 187 && instruction instanceof TypeInsnNode && "java/io/ObjectInputStream".equals(((TypeInsnNode)instruction).desc)) {
                    ((TypeInsnNode)instruction).desc = "io/dogboy/serializationisbad/core/ClassFilteringObjectInputStream";
                    SerializationIsBad.logger.info("  (1/2) Redirecting ObjectInputStream to ClassFilteringObjectInputStream in method " + methodNode.name);
                    continue;
                }
                if (instruction.getOpcode() != 183 || !(instruction instanceof MethodInsnNode) || !"java/io/ObjectInputStream".equals(((MethodInsnNode)instruction).owner) || !"<init>".equals(((MethodInsnNode)instruction).name)) continue;
                ((MethodInsnNode)instruction).owner = "io/dogboy/serializationisbad/core/ClassFilteringObjectInputStream";
                ((MethodInsnNode)instruction).desc = "(Ljava/io/InputStream;Lio/dogboy/serializationisbad/core/config/PatchModule;)V";
                InsnList additionalInstructions = new InsnList();
                additionalInstructions.add((AbstractInsnNode)new LdcInsnNode((Object)className));
                additionalInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "io/dogboy/serializationisbad/core/Patches", "getPatchModuleForClass", "(Ljava/lang/String;)Lio/dogboy/serializationisbad/core/config/PatchModule;", false));
                instructions.insertBefore(instruction, additionalInstructions);
                SerializationIsBad.logger.info("  (2/2) Redirecting ObjectInputStream to ClassFilteringObjectInputStream in method " + methodNode.name);
            }
        }
    }
}

