/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.IClickable;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.render.MuseRenderer;

public class ClickableLabel
implements IClickable {
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected String label;
    protected MusePoint2D position;
    protected int mode;

    public ClickableLabel(String label, MusePoint2D position) {
        this.label = label;
        this.position = position;
        this.mode = 1;
    }

    public ClickableLabel(String label, MusePoint2D position, int mode) {
        this.label = label;
        this.position = position;
        this.mode = mode;
    }

    public ClickableLabel setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.mode == 0) {
            MuseRenderer.drawLeftAlignedStringString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
        if (this.mode == 1) {
            MuseRenderer.drawCenteredString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
        if (this.mode == 2) {
            MuseRenderer.drawRightAlignedString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
    }

    @Override
    public boolean containsPoint(double mouseX, double mouseY) {
        if (this.label == null || this.label.isEmpty()) {
            return false;
        }
        MusePoint2D radius = new MusePoint2D(MuseRenderer.getStringWidth(this.label) / 2.0 + 2.0, 6.0);
        boolean hitx = Math.abs(this.position.getX() - mouseX) < radius.getX();
        boolean hity = Math.abs(this.position.getY() - mouseY) < radius.getY();
        return hitx && hity;
    }

    @Override
    public List<String> getToolTip(double mouseX, double mouseY) {
        return null;
    }

    @Override
    public void move(double x, double y) {
        this.position.setX(x);
        this.position.setY(y);
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    @Override
    public void enable() {
        this.enabled = false;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }
}

