/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.IClickable;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.math.Colour;

public class ClickableButton2
extends DrawableMuseRect
implements IClickable {
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    boolean enabled = true;
    boolean visible = true;
    public String label;
    Colour labelColor = Colour.WHITE;

    public ClickableButton2(double left, double top, double width, boolean enabled) {
        super(left, top, left + width, top + 20.0, new Colour(0.5, 0.6f, 0.8f, 1.0), new Colour(0.3f, 0.3f, 0.3f, 1.0));
        this.enabled = enabled;
    }

    public ClickableButton2(double left, double top, double width, boolean enabled, Colour insideColour, Colour outsideColour) {
        super(left, top, left + width, top + 20.0, insideColour, outsideColour);
        this.enabled = enabled;
    }

    public ClickableButton2(double left, double top, double width) {
        super(left, top, left + width, top + 20.0, new Colour(0.5, 0.6f, 0.8f, 1.0), new Colour(0.3f, 0.3f, 0.3f, 1.0));
    }

    public ClickableButton2(double left, double top, double width, Colour insideColour, Colour outsideColour) {
        super(left, top, left + width, top + 20.0, insideColour, outsideColour);
    }

    @Override
    public void render(double mouseX, double mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.visible) {
            Colour bottomcolour;
            Colour topcolour;
            if (this.isEnabled()) {
                topcolour = new Colour(0.5, 0.6f, 0.8f, 1.0);
                bottomcolour = new Colour(0.3f, 0.3f, 0.3f, 1.0);
            } else {
                topcolour = new Colour(0.8f, 0.3f, 0.3f, 1.0);
                bottomcolour = new Colour(0.8f, 0.6f, 0.6f, 1.0);
            }
            this.setOutsideColour(topcolour);
            this.setInsideColour(bottomcolour);
            super.render(mouseX, mouseY, partialTicks);
            MuseRenderer.drawCenteredString(this.label, this.centerX(), this.centerY() - 4.0);
        }
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public MusePoint2D getPosition() {
        return this.center();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public List getToolTip(double mouseX, double mouseY) {
        return null;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return super.containsPoint(x, y);
    }
}

