/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockFloatingSpecialFlower
extends BlockFloatingFlower
implements ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD {
    public BlockFloatingSpecialFlower() {
        super("floatingSpecialFlower");
    }

    @Override
    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.SUBTILE_ID, BotaniaStateProps.ISLAND_TYPE});
    }

    @Override
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        state = super.getExtendedState(state, world, pos);
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileFloatingSpecialFlower) {
            state = ((IExtendedBlockState)state).withProperty(BotaniaStateProps.SUBTILE_ID, (Object)((TileFloatingSpecialFlower)te).subTileName);
        }
        return state;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return world.func_180495_p(pos).getLightValue(world, pos);
        }
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileSpecialFlower ? ((TileSpecialFlower)tile).getLightValue() : this.field_149784_t;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            stacks.add((Object)ItemBlockSpecialFlower.ofType(new ItemStack((Block)this), s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            stacks.add((Object)ItemBlockSpecialFlower.ofType(new ItemStack((Block)this), (String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        String name = ((TileSpecialFlower)world.func_175625_s((BlockPos)pos)).subTileName;
        return ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockHarvested(world, pos, state, player);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add((Object)ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name));
            ((TileSpecialFlower)tile).getDrops((List<ItemStack>)list);
        }
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onWanded(stack, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ) || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpecialFlower)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileFloatingSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getEntry();
    }
}

