/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.silvercatcher.reforged.ReforgedReferences;
import org.silvercatcher.reforged.ReforgedRegistry;
import org.silvercatcher.reforged.entities.EntityBoomerang;
import org.silvercatcher.reforged.entities.EntityBulletBlunderbuss;
import org.silvercatcher.reforged.entities.EntityBulletMusket;
import org.silvercatcher.reforged.entities.EntityCrossbowBolt;
import org.silvercatcher.reforged.entities.EntityDart;
import org.silvercatcher.reforged.entities.EntityDummy;
import org.silvercatcher.reforged.entities.EntityDynamite;
import org.silvercatcher.reforged.entities.EntityJavelin;
import org.silvercatcher.reforged.entities.TileEntityCaltrop;
import org.silvercatcher.reforged.gui.ReloadOverlay;
import org.silvercatcher.reforged.proxy.CommonProxy;
import org.silvercatcher.reforged.render.RenderBoomerang;
import org.silvercatcher.reforged.render.RenderBulletBlunderbuss;
import org.silvercatcher.reforged.render.RenderBulletMusket;
import org.silvercatcher.reforged.render.RenderCrossbowBolt;
import org.silvercatcher.reforged.render.RenderDart;
import org.silvercatcher.reforged.render.RenderDummy;
import org.silvercatcher.reforged.render.RenderDynamite;
import org.silvercatcher.reforged.render.RenderJavelin;
import org.silvercatcher.reforged.render.RenderTileEntityCaltrop;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new ReloadOverlay());
        this.registerEntityRenderers();
    }

    @Override
    protected void registerEntityRenderers() {
        if (ReforgedReferences.GlobalValues.BOOMERANG) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBoomerang.class, RenderBoomerang::new);
        }
        if (ReforgedReferences.GlobalValues.CROSSBOW) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCrossbowBolt.class, RenderCrossbowBolt::new);
        }
        if (ReforgedReferences.GlobalValues.MUSKET) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBulletMusket.class, RenderBulletMusket::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityBulletBlunderbuss.class, RenderBulletBlunderbuss::new);
        }
        if (ReforgedReferences.GlobalValues.JAVELIN) {
            RenderingRegistry.registerEntityRenderingHandler(EntityJavelin.class, RenderJavelin::new);
        }
        if (ReforgedReferences.GlobalValues.BLOWGUN) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDart.class, RenderDart::new);
        }
        if (ReforgedReferences.GlobalValues.CALTROP) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCaltrop.class, (TileEntitySpecialRenderer)new RenderTileEntityCaltrop());
        }
        if (ReforgedReferences.GlobalValues.DYNAMITE) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, RenderDynamite::new);
        }
        if (ReforgedReferences.GlobalValues.DUMMY) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDummy.class, RenderDummy::new);
        }
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        super.registerItemRenderer(item, meta, id);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("reforged:" + id, "inventory"));
    }

    @Override
    @SubscribeEvent
    protected void registerItemRenderers(ModelRegistryEvent event) {
        String inventory = "inventory";
        for (Item item : ReforgedRegistry.registrationList) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("reforged:" + item.func_77658_a().substring(5), inventory));
        }
        for (Block block : ReforgedRegistry.registrationListBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("reforged:" + block.func_149739_a().substring(5), inventory));
        }
    }
}

