/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SkinMap {
    public static final String[] FACE_NAMES = new String[]{"skin_d", "skin_u", "skin_n", "skin_s", "skin_w", "skin_e"};
    public final ImmutableMap<String, String> textures;

    public static SkinMap of(String v) {
        HashMap<String, String> textures = new HashMap<String, String>();
        Map map = StringUtils.parse((Map)StringUtils.TEMP_MAP, (String)v);
        String s = (String)map.get("all");
        for (String string : FACE_NAMES) {
            textures.put(string, s == null ? "blocks/planks_oak" : s);
        }
        for (String string : EnumFacing.field_82609_l) {
            s = (String)map.get(string.func_176610_l());
            if (s == null) continue;
            textures.put(FACE_NAMES[string.func_176745_a()], s);
        }
        return new SkinMap(textures);
    }

    private SkinMap(Map<String, String> map) {
        this.textures = ImmutableMap.builder().putAll(map).build();
    }

    public Collection<ResourceLocation> getTextures() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String s : this.textures.values()) {
            set.add(new ResourceLocation(s));
        }
        return set;
    }

    public TextureAtlasSprite get(EnumFacing facing, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return bakedTextureGetter.apply(new ResourceLocation((String)this.textures.get((Object)FACE_NAMES[facing.func_176745_a()])));
    }
}

