/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.crafting;

import java.util.ArrayList;
import mod.lucky.crafting.CraftingLuckModifier;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.item.ItemLuckyPotion;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LuckyCrafting
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private Block luckCraftingBlock;
    private Item luckCraftingItem;
    private ArrayList<CraftingLuckModifier> luckModifiers;
    private ItemStack resultItemStack;

    public LuckyCrafting(Block luckCraftingBlock) {
        this.luckCraftingBlock = luckCraftingBlock;
        this.luckModifiers = new ArrayList();
        this.luckModifiers.add(new CraftingLuckModifier(Items.field_151034_e, 0, 20));
    }

    public LuckyCrafting(Item luckCraftingItem) {
        this.luckCraftingItem = luckCraftingItem;
        this.luckModifiers = new ArrayList();
    }

    public boolean func_77569_a(InventoryCrafting craftingTable, World world) {
        int baseLuckLevel = 0;
        int itemLuckLevelTotal = 0;
        boolean foundLuckyCraftingItem = false;
        ItemStack originalLuckyBlock = null;
        for (int i = 0; i < craftingTable.func_70302_i_(); ++i) {
            ItemStack itemStack = craftingTable.func_70301_a(i);
            if (itemStack == ItemStack.field_190927_a) continue;
            if (this.luckCraftingItem != null ? itemStack.func_77973_b() == this.luckCraftingItem : this.luckCraftingBlock != null && itemStack.func_77973_b() == Item.func_150898_a((Block)this.luckCraftingBlock)) {
                if (originalLuckyBlock != null) {
                    return false;
                }
                baseLuckLevel = ItemLuckyBlock.getLuck(itemStack);
                originalLuckyBlock = itemStack;
                continue;
            }
            boolean matchesLuckyItems = false;
            int luckyItemLuck = 0;
            for (int j = 0; j < this.luckModifiers.size(); ++j) {
                if (itemStack.func_77973_b() != this.luckModifiers.get(j).getItem() || itemStack.func_77952_i() != this.luckModifiers.get(j).getDamage() && this.luckModifiers.get(j).getDamage() != -1) continue;
                matchesLuckyItems = true;
                luckyItemLuck = this.luckModifiers.get(j).getLuckValue();
                if (!(this.luckCraftingItem instanceof ItemLuckyPotion)) continue;
                luckyItemLuck *= 4;
            }
            if (!matchesLuckyItems) {
                return false;
            }
            foundLuckyCraftingItem = true;
            itemLuckLevelTotal += luckyItemLuck;
        }
        if (originalLuckyBlock == null || !foundLuckyCraftingItem) {
            return false;
        }
        int resultLuckLevel = baseLuckLevel + itemLuckLevelTotal;
        if (resultLuckLevel > 100) {
            resultLuckLevel = 100;
        }
        if (resultLuckLevel < -100) {
            resultLuckLevel = -100;
        }
        if (baseLuckLevel == 100 && resultLuckLevel == 100) {
            return false;
        }
        if (baseLuckLevel == -100 && resultLuckLevel == -100) {
            return false;
        }
        this.resultItemStack = originalLuckyBlock.func_77946_l();
        this.resultItemStack.func_190920_e(1);
        if (resultLuckLevel != 0) {
            NBTTagCompound tag = this.resultItemStack.func_77978_p();
            if (this.resultItemStack.func_77978_p() == null) {
                this.resultItemStack.func_77982_d(new NBTTagCompound());
            }
            this.resultItemStack.func_77978_p().func_74768_a("Luck", resultLuckLevel);
        } else {
            this.resultItemStack.func_77982_d(null);
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting table) {
        return this.resultItemStack.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)new ItemStack(Items.field_151055_y));
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public String func_193358_e() {
        return "lucky";
    }

    public boolean func_192399_d() {
        return true;
    }

    public void addLuckModifier(CraftingLuckModifier luckModifier) {
        this.luckModifiers.add(luckModifier);
    }
}

