/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.chococraft.common.ChocoConfig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class RetrogenManager {
    private static Map<World, Set<ChunkPos>> pendingWork = new HashMap<World, Set<ChunkPos>>();
    private static Map<World, Set<ChunkPos>> completedWork = new HashMap<World, Set<ChunkPos>>();

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
        if (!(event.getWorld() instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.getWorld();
        Set completedChunks = completedWork.computeIfAbsent((World)world, k -> new HashSet());
        if (completedChunks.contains(event.getChunk().func_76632_l())) {
            return;
        }
        int version = event.getData().func_74762_e("CHOCOCRAFT_RG");
        if (version >= ChocoConfig.world.retrogenId) {
            return;
        }
        pendingWork.computeIfAbsent((World)world, w -> new HashSet()).add(event.getChunk().func_76632_l());
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.getWorld();
        Set<ChunkPos> completedChunks = completedWork.get(world);
        if (completedChunks != null && completedChunks.contains(event.getChunk().func_76632_l())) {
            NBTTagCompound data = event.getData();
            data.func_74768_a("CHOCOCRAFT_RG", 1);
            completedChunks.remove(event.getChunk().func_76632_l());
        }
    }
}

