/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import de.eydamos.backpack.Features;
import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.item.EFrame;
import de.eydamos.backpack.item.EPiece;
import de.eydamos.backpack.item.EStick;
import de.eydamos.backpack.misc.Constants;
import de.eydamos.backpack.misc.EItemStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFunctionless
extends Item {
    public ItemFunctionless(String unlocalizedName) {
        this(unlocalizedName, 64, false);
    }

    public ItemFunctionless(String unlocalizedName, int maxStackSize) {
        this(unlocalizedName, maxStackSize, false);
    }

    public ItemFunctionless(String unlocalizedName, int maxStackSize, boolean hasSubTypes) {
        this.setRegistryName(unlocalizedName);
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(maxStackSize);
        this.func_77627_a(hasSubTypes);
        this.func_77637_a(Constants.tabBackpacks);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        switch (this.func_77658_a()) {
            case "item.stick": {
                for (EStick stick : EStick.values()) {
                    if (!stick.isEnabled()) continue;
                    subItems.add((Object)EItemStack.getItemStack(BackpackItems.stick, 1, stick.getDamage()));
                }
                break;
            }
            case "item.backpack_frame": {
                for (EFrame frame : EFrame.values()) {
                    if (!Features.BACKPACK_FRAME.isEnabled() || !frame.isEnabled()) continue;
                    subItems.add((Object)EItemStack.getItemStack(BackpackItems.backpack_frame, 1, frame.getDamage()));
                }
                break;
            }
            case "item.backpack_piece": {
                for (EPiece piece : EPiece.values()) {
                    if (!Features.BACKPACK_PIECE.isEnabled()) continue;
                    subItems.add((Object)EItemStack.getItemStack(BackpackItems.backpack_piece, 1, piece.getDamage()));
                }
                break;
            }
            case "item.bound_leather": {
                if (!Features.LEATHER_BOUND.isEnabled()) break;
                subItems.add((Object)EItemStack.BOUND_LEATHER.getItemStack(1));
                break;
            }
            case "item.tanned_leather": {
                if (!Features.LEATHER_TANNED.isEnabled()) break;
                subItems.add((Object)EItemStack.TANNED_LEATHER.getItemStack(1));
            }
        }
    }

    @MethodsReturnNonnullByDefault
    public String func_77667_c(ItemStack itemStack) {
        String name;
        switch (name = super.func_77667_c(itemStack)) {
            case "item.stick": {
                name = name + "_" + EStick.getIdentifierByDamage(itemStack.func_77952_i());
                break;
            }
            case "item.backpack_frame": {
                name = name + '_' + EFrame.getIdentifierByDamage(itemStack.func_77952_i());
                break;
            }
            case "item.backpack_piece": {
                name = name + '_' + EPiece.getIdentifierByDamage(itemStack.func_77952_i());
            }
        }
        return name;
    }
}

