/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.proto.bin;

import drew6017.lr.api.aparser.ProtoParse;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.api.proto.Protocol;
import drew6017.lr.api.proto.ProtocolCategory;
import drew6017.lr.api.proto.help.HelpFormatter;
import drew6017.lr.util.Counter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CCItems
implements LRProtocol {
    public static Counter counter;
    private static String help;

    @Override
    public void init() {
        counter = Protocol.getCounter(this);
    }

    @Override
    public String id() {
        return "cc_items";
    }

    @Override
    public String help() {
        return help;
    }

    @Override
    public ProtocolCategory[] category() {
        return new ProtocolCategory[]{ProtocolCategory.CPU, ProtocolCategory.RAM, ProtocolCategory.NETWORK};
    }

    @Override
    public LRProtocolResult run(Object[] args) {
        LRProtocolResult result;
        boolean count = (Boolean)args[0];
        if (args.length == 1) {
            final int i = this.clearItems(count);
            result = new LRProtocolResult(this){

                @Override
                public Object[] getData() {
                    return new Object[]{i};
                }
            };
        } else if (args.length == 2) {
            final int i = args[1] instanceof World ? this.clearItems(((World)args[1]).getEntities(), count) : this.clearItems(Arrays.asList(((Chunk)args[1]).getEntities()), count);
            result = new LRProtocolResult(this){

                @Override
                public Object[] getData() {
                    return new Object[]{i};
                }
            };
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public ProtoParse getPP() {
        return new ProtoParse(){

            @Override
            public HashMap<String, ProtoParse.ProtoParseData> getKeysToClass() {
                HashMap<String, ProtoParse.ProtoParseData> k = new HashMap<String, ProtoParse.ProtoParseData>();
                k.put("Count", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.BOOLEAN, 0));
                k.put("World", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.WORLD, 1));
                k.put("Chunk", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.CHUNK, 1));
                return k;
            }
        };
    }

    private int clearItems(List<Entity> ents, boolean count) {
        int i = 0;
        for (Entity e : ents) {
            if (!e.getType().equals((Object)EntityType.DROPPED_ITEM)) continue;
            if (!count) {
                e.remove();
            }
            ++i;
        }
        return i;
    }

    private int clearItems(boolean count) {
        int i = 0;
        for (World w : Bukkit.getWorlds()) {
            i += this.clearItems(w.getEntities(), count);
        }
        return i;
    }

    static {
        help = new HelpFormatter().set(HelpFormatter.HelpFormatterType.DESCRIPTION, "\u00a7eRemoves items from all worlds, selected worlds, or selected chunks.").set(HelpFormatter.HelpFormatterType.CATEGORIES, "\u00a7eCPU, RAM, and NETWORK").set(HelpFormatter.HelpFormatterType.ARGUMENTS, HelpFormatter.generateArgs(new CCItems().getPP())).set(HelpFormatter.HelpFormatterType.RETURNS, "\u00a7e{0: <(int)CCed>}").make();
    }
}

