/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.proto.bin;

import drew6017.lr.api.aparser.ProtoParse;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.api.proto.Protocol;
import drew6017.lr.api.proto.ProtocolCategory;
import drew6017.lr.api.proto.help.HelpFormatter;
import drew6017.lr.util.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;

public class CCEntities
implements LRProtocol {
    public static EntityType[] hostile;
    public static EntityType[] peaceful;
    public static Counter counter;
    private static String help;

    @Override
    public void init() {
        counter = Protocol.getCounter(this);
    }

    @Override
    public String id() {
        return "cc_entities";
    }

    @Override
    public String help() {
        return help;
    }

    @Override
    public ProtocolCategory[] category() {
        return new ProtocolCategory[]{ProtocolCategory.CPU, ProtocolCategory.RAM, ProtocolCategory.NETWORK};
    }

    @Override
    public LRProtocolResult run(Object[] args) {
        LRProtocolResult result;
        boolean count = (Boolean)args[0];
        EntityType[] toClear = (EntityType[])args[1];
        if (args.length == 2) {
            final int i = this.clearEntities(count, toClear);
            result = new LRProtocolResult(this){

                @Override
                public Object[] getData() {
                    return new Object[]{i};
                }
            };
        } else if (args.length == 3) {
            int i;
            if (args[2] instanceof World) {
                i = CCEntities.clearEntities(((World)args[2]).getEntities(), count, toClear);
            } else if (args[2] instanceof Chunk) {
                i = CCEntities.clearEntities(Arrays.asList(((Chunk)args[2]).getEntities()), count, toClear);
            } else if (args[2] instanceof Boolean) {
                int ii = 0;
                for (World w : Bukkit.getWorlds()) {
                    ii += CCEntities.clearEntities(w.getEntities(), count, toClear);
                }
                i = ii;
            } else {
                i = 0;
            }
            result = new LRProtocolResult(this){

                @Override
                public Object[] getData() {
                    return new Object[]{i};
                }
            };
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public ProtoParse getPP() {
        return new ProtoParse(){

            @Override
            public HashMap<String, ProtoParse.ProtoParseData> getKeysToClass() {
                HashMap<String, ProtoParse.ProtoParseData> k = new HashMap<String, ProtoParse.ProtoParseData>();
                k.put("Count", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.BOOLEAN, 0));
                k.put("ToClear", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.ENTITY_TYPE_ARRAY, 1));
                k.put("World", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.WORLD, 2));
                k.put("Chunk", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.CHUNK, 2));
                k.put("AllWorlds", new ProtoParse.ProtoParseData(ProtoParse.ProtoParseKeywords.BOOLEAN, 2));
                return k;
            }
        };
    }

    public static int clearEntities(List<Entity> ents, boolean count, EntityType ... include) {
        int i = 0;
        for (Entity e : ents) {
            if (e.getType().equals((Object)EntityType.PLAYER) || !CCEntities.orAll(e.getType(), include)) continue;
            if (!count) {
                e.remove();
            }
            ++i;
        }
        return i;
    }

    private int clearEntities(boolean count, EntityType ... include) {
        int i = 0;
        for (World w : Bukkit.getWorlds()) {
            i += CCEntities.clearEntities(w.getEntities(), count, include);
        }
        return i;
    }

    private static boolean orAll(EntityType e, EntityType ... all) {
        if (all == null) {
            return true;
        }
        for (EntityType ent : all) {
            if (!e.equals((Object)ent)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<EntityType> hostEnts = new ArrayList<EntityType>();
        ArrayList<EntityType> peaceEnts = new ArrayList<EntityType>();
        for (EntityType ent : EntityType.values()) {
            if (ent.getEntityClass() == null || !LivingEntity.class.isAssignableFrom(ent.getEntityClass())) continue;
            if (Monster.class.isAssignableFrom(ent.getEntityClass())) {
                hostEnts.add(ent);
                continue;
            }
            peaceEnts.add(ent);
        }
        hostile = hostEnts.toArray(new EntityType[hostEnts.size()]);
        peaceful = peaceEnts.toArray(new EntityType[peaceEnts.size()]);
        help = new HelpFormatter().set(HelpFormatter.HelpFormatterType.DESCRIPTION, "\u00a7eRemoves entities from all worlds, selected worlds, or selected chunks.").set(HelpFormatter.HelpFormatterType.CATEGORIES, "\u00a7eCPU, RAM, and NETWORK").set(HelpFormatter.HelpFormatterType.ARGUMENTS, HelpFormatter.generateArgs(new CCEntities().getPP())).set(HelpFormatter.HelpFormatterType.RETURNS, "\u00a7e{0: <(int)CCed>}").make();
    }
}

