/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.main;

import drew6017.lr.api.aparser.AnfoParser;
import drew6017.lr.api.proto.DelayedLRProtocolResult;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.api.proto.Protocol;
import drew6017.lr.api.vcon.VCon;
import drew6017.lr.inf.Help;
import drew6017.lr.main.LaggRemover;
import drew6017.lr.main.TPS;
import drew6017.lr.proto.bin.CCEntities;
import drew6017.lr.proto.bin.CCItems;
import drew6017.lr.proto.bin.LRGC;
import drew6017.lr.util.BitString;
import drew6017.lr.util.DoubleVar;
import drew6017.lr.util.DrewMath;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.json.simple.parser.ParseException;

public class LRCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean onCommand(final Player p, String[] args) {
        World w;
        int i;
        ArrayList<EntityType> types;
        boolean isCount;
        block91: {
            block92: {
                block93: {
                    EntityType[] ents;
                    block90: {
                        block94: {
                            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("h")) {
                                if (!LRCommand.hasPerm(p, "lr.help")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (args.length == 1) {
                                    Help.send(p, 1);
                                    return true;
                                }
                                try {
                                    Help.send(p, Integer.parseInt(args[1]));
                                    return true;
                                }
                                catch (Exception ex) {
                                    Help.sendMsg(p, "\u00a7cPlease enter a valid number!", true);
                                    return true;
                                }
                            }
                            if (args[0].equalsIgnoreCase("master") || args[0].equalsIgnoreCase("m")) {
                                if (!LRCommand.hasPerm(p, "lr.master")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                Runtime r = Runtime.getRuntime();
                                long chunks = 0L;
                                long entities = 0L;
                                long players = 0L;
                                long ram_used = (r.totalMemory() - r.freeMemory()) / 1024L / 1024L;
                                long ram_total = r.maxMemory() / 1024L / 1024L;
                                for (World w2 : Bukkit.getWorlds()) {
                                    chunks += (long)w2.getLoadedChunks().length;
                                    entities += (long)w2.getEntities().size();
                                    players += (long)w2.getPlayers().size();
                                }
                                double avPing = 0.0;
                                double pps = 0.0;
                                if (VCon.isSupported()) {
                                    for (Player pp : Bukkit.getOnlinePlayers()) {
                                        int ping = VCon.a.getPing(pp);
                                        if (ping > 10000) continue;
                                        avPing += (double)ping;
                                        pps += 1.0;
                                    }
                                    if (pps != 0.0) {
                                        avPing /= pps;
                                    }
                                }
                                String s = p == null ? "" : BitString.SQUARE.getComp();
                                StringBuilder sb = new StringBuilder();
                                sb.append("\n                      \u00a77\u00a7l--->> \u00a76\u00a7lLaggRemover \u00a77\u00a7l<<---\u00a7r");
                                sb.append("\n\u00a7e").append(s).append(" Worlds:\u00a77 ").append(Bukkit.getWorlds().size());
                                sb.append("\n\u00a7e").append(s).append(" TPS:\u00a77 ").append(Double.toString(DrewMath.round(TPS.getTPS(), 2)));
                                sb.append("\n\u00a7e").append(s).append(" RAM:\u00a77 ").append(NumberFormat.getNumberInstance().format(ram_used)).append(" / ").append(NumberFormat.getNumberInstance().format(ram_total)).append("MB (").append(Double.toString(DrewMath.round((double)ram_used / (double)ram_total * 100.0, 1))).append("%)");
                                sb.append("\n\u00a7e").append(s).append(" Loaded Chunks:\u00a77 ").append(NumberFormat.getNumberInstance().format(chunks));
                                sb.append("\n\u00a7e").append(s).append(" Entities:\u00a77 ").append(NumberFormat.getNumberInstance().format(entities));
                                sb.append("\n\u00a7e").append(s).append(" Players:\u00a77 ").append(NumberFormat.getNumberInstance().format(players));
                                sb.append("\n\u00a7e").append(s).append(" Avg. Ping:\u00a77 ");
                                if (VCon.isSupported()) {
                                    if (pps == 0.0) {
                                        sb.append("(no players)");
                                    } else {
                                        sb.append(NumberFormat.getNumberInstance().format(DrewMath.round(avPing, 1))).append("ms");
                                    }
                                } else {
                                    sb.append("Not supported");
                                }
                                Help.sendMsg(p, sb.toString(), false);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("ram")) {
                                if (LRCommand.hasPerm(p, "lr.ram")) {
                                    Runtime r = Runtime.getRuntime();
                                    long ram_used = (r.totalMemory() - r.freeMemory()) / 1024L / 1024L;
                                    long ram_total = r.maxMemory() / 1024L / 1024L;
                                    Help.sendMsg(p, "\u00a7eRAM:\u00a77 " + NumberFormat.getNumberInstance().format(ram_used) + " / " + NumberFormat.getNumberInstance().format(ram_total) + "MB (" + Double.toString(DrewMath.round((double)ram_used / (double)ram_total * 100.0, 1)) + "%)", true);
                                    return true;
                                }
                                LRCommand.noPerm(p);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("i")) {
                                Help.sendMsg(p, "\u00a76\u00a7lLaggRemover\n \u00a7aAuthor: \u00a7edrew6017\n \u00a7aVersion: \u00a7e" + LaggRemover.lr.getDescription().getVersion() + "\n \u00a7aWebsite: \u00a7ehttp://dev.bukkit.org/bukkit-plugins/laggremover/\n \u00a7aDonate: \u00a7ehttps://goo.gl/1q3wN5\n \u00a7aInfo: \u00a7eLaggRemover \u00a77was created by drew6017 to help server owners grow their servers to a professional level by improving performance and automating server care to keep players and owners happy.", false);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("world") || args[0].equalsIgnoreCase("w")) {
                                World w3;
                                if (!LRCommand.hasPerm(p, "lr.world")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (args.length == 2) {
                                    w3 = Bukkit.getWorld((String)args[1]);
                                } else {
                                    if (p == null) {
                                        LaggRemover.lr.getLogger().info("You must be a player to not specify an argument here.");
                                        return true;
                                    }
                                    w3 = p.getWorld();
                                }
                                if (w3 == null) {
                                    Help.sendMsg(p, "\u00a7cThe world specified was invalid or not found.", true);
                                    return true;
                                }
                                long size = DrewMath.getSize(w3.getWorldFolder());
                                String s = p == null ? "" : BitString.SQUARE.getComp();
                                Help.sendMsg(p, "\u00a76\u00a7lWorld " + w3.getName() + "\u00a7r\n\u00a7e" + s + " Seed:\u00a77 " + Long.toString(w3.getSeed()) + "\n\u00a7e" + s + " Spawn Chunks:\u00a77 " + (w3.getKeepSpawnInMemory() ? "Yes" : "No") + "\n\u00a7e" + s + " Loaded Chunks:\u00a77 " + NumberFormat.getNumberInstance().format(w3.getLoadedChunks().length) + "\n\u00a7e" + s + " Entities:\u00a77 " + NumberFormat.getNumberInstance().format(w3.getEntities().size()) + "\n\u00a7e" + s + " Players:\u00a77 " + NumberFormat.getNumberInstance().format(w3.getPlayers().size()) + "\n\u00a7e" + s + " Time:\u00a77 " + Long.toString(w3.getTime()) + " (" + DrewMath.getTagForTime(w3.getTime()) + ")\n\u00a7e" + s + " Size on Disk:\u00a77 " + NumberFormat.getNumberInstance().format(size / 1000L) + "KB (" + NumberFormat.getNumberInstance().format(size) + " bytes)", true);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("gc")) {
                                if (LRCommand.hasPerm(p, "lr.gc")) {
                                    Help.sendMsg(p, "\u00a7eLaggRemover's garbage collector has been run and has freed \u00a7b" + NumberFormat.getNumberInstance().format(Protocol.run(new LRGC(), null).getData()[0]) + "MB\u00a7e of RAM on your server.", true);
                                    return true;
                                }
                                LRCommand.noPerm(p);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("tps")) {
                                if (!LRCommand.hasPerm(p, "lr.tps")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (p == null) {
                                    LaggRemover.lr.getLogger().info("TPS: " + Double.toString(DrewMath.round(TPS.getTPS(), 2)));
                                    return true;
                                }
                                Help.sendMsg(p, "\u00a7eTPS: " + TPS.format(), true);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("modules") || args[0].equalsIgnoreCase("mo")) {
                                if (LRCommand.hasPerm(p, "lr.modules")) {
                                    String[] ms = LaggRemover.getModulesList();
                                    Help.sendMsg(p, "\u00a7eModules (" + ms[1] + "): \u00a7a" + ms[0], true);
                                    return true;
                                }
                                LRCommand.noPerm(p);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("protocol") || args[0].equalsIgnoreCase("pr")) {
                                if (!LRCommand.hasPerm(p, "lr.protocol")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (args.length < 2) {
                                    Help.sendMsg(p, "\u00a7cCorrect usage: /lr protocol(p) [help(h):run(r):list(l)] <options>", true);
                                    return true;
                                }
                                if (args[1].equalsIgnoreCase("help") || args[1].equalsIgnoreCase("h")) {
                                    if (args.length == 2) {
                                        Help.sendMsg(p, "\u00a7eYou can use this command to view the help and description of all of the protocols currently loaded into LaggRemover. Simply type:\n /lr protocol(p) help(h) <protocol>", true);
                                        return true;
                                    }
                                    String pname = args[2].toLowerCase();
                                    Help.sendMsg(p, "\u00a76\u00a7lProtocol " + pname + "\u00a7r\n" + Protocol.getProtocol(pname).help(), false);
                                    return true;
                                }
                                if (args[1].equalsIgnoreCase("run") || args[1].equalsIgnoreCase("r")) {
                                    DoubleVar<Object[], Boolean> dat;
                                    String raw_fin;
                                    Help.sendMsg(p, "\u00a7cThis feature is not fully supported yet. Expect bugs.", true);
                                    if (args.length < 4) {
                                        Help.sendMsg(p, "\u00a7cCorrect usage: /lr protocol(p) run(r) <protocol> <(Boolean)seeRawResult> <data>", true);
                                        return true;
                                    }
                                    StringBuilder sb = new StringBuilder();
                                    if (args.length > 4) {
                                        for (int i2 = 5; i2 < args.length; ++i2) {
                                            sb.append(args[i2]).append(" ");
                                        }
                                        raw_fin = sb.toString();
                                        raw_fin = raw_fin.substring(0, raw_fin.length() - 1);
                                    } else {
                                        raw_fin = "{\"Delay\":\"false\"}";
                                    }
                                    LRProtocol pk = Protocol.getProtocol(args[2]);
                                    final boolean seeResult = Boolean.parseBoolean(args[3].toLowerCase());
                                    try {
                                        dat = AnfoParser.parse(pk, raw_fin);
                                    }
                                    catch (AnfoParser.AnfoParseException | ParseException e) {
                                        Help.sendMsg(p, "\u00a7cError parsing protocol: \u00a77" + e.getMessage(), true);
                                        Help.sendMsg(p, "\u00a7cMaybe you used the command invalidly? Correct usage: /lr protocol(p) run(r) <protocol> <(Boolean)seeRawResult> <data>", true);
                                        return true;
                                    }
                                    if (dat.getVar2().booleanValue()) {
                                        Protocol.rund(pk, dat.getVar1(), new DelayedLRProtocolResult(){

                                            @Override
                                            public void receive(LRProtocolResult result) {
                                                if (seeResult) {
                                                    Help.sendProtocolResultInfo(p, result);
                                                }
                                            }
                                        });
                                        return true;
                                    }
                                    if (!seeResult) return true;
                                    Help.sendProtocolResultInfo(p, pk.run(dat.getVar1()));
                                    return true;
                                }
                                if (!args[1].equalsIgnoreCase("list")) {
                                    if (!args[1].equalsIgnoreCase("l")) return true;
                                }
                                String[] ms = LaggRemover.getProtocolList();
                                Help.sendMsg(p, "\u00a7eProtocols (" + ms[1] + "): \u00a7a" + ms[0], true);
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("unload") || args[0].equalsIgnoreCase("u")) {
                                if (!LRCommand.hasPerm(p, "lr.unload")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (args.length != 2) {
                                    Help.sendMsg(p, "\u00a7cCorrect usage: /lr unload(u) <world>", true);
                                    return true;
                                }
                                World w4 = Bukkit.getWorld((String)args[1]);
                                if (w4 == null) {
                                    Help.sendMsg(p, "\u00a7cWorld \"" + args[1] + "\" could not be found.", true);
                                    return true;
                                }
                                if (w4.getPlayers().size() != 0) {
                                    Help.sendMsg(p, "\u00a7cUnloading the chunks of worlds that contain players has been disabled due to bugs.", true);
                                    return true;
                                }
                                int chunks = 0;
                                Chunk[] pk = w4.getLoadedChunks();
                                int seeResult = pk.length;
                                int dat = 0;
                                while (true) {
                                    if (dat >= seeResult) {
                                        Help.sendMsg(p, "\u00a7e" + Integer.toString(chunks) + " chunks in world " + w4.getName() + " have been unloaded", true);
                                        return true;
                                    }
                                    Chunk c = pk[dat];
                                    w4.unloadChunk(c);
                                    ++chunks;
                                    ++dat;
                                }
                            }
                            if (args[0].equalsIgnoreCase("ping") || args[0].equalsIgnoreCase("p")) {
                                if (!LRCommand.hasPerm(p, "lr.ping")) {
                                    LRCommand.noPerm(p);
                                    return true;
                                }
                                if (args.length == 2) {
                                    Player p1 = Bukkit.getPlayer((String)args[1]);
                                    if (p1 == null) {
                                        Help.sendMsg(p, "\u00a7c\"" + args[1] + "\" is not a valid player.", true);
                                        return true;
                                    }
                                    Help.sendMsg(p, "\u00a7ePlayer \"" + args[1] + "\" has a ping of \u00a7b" + Integer.toString(VCon.a.getPing(p1)) + "\u00a7ems", true);
                                    return true;
                                }
                                if (args.length != 1) {
                                    Help.sendMsg(p, "\u00a7cCorrect usage: /lr ping(p) <player:none>", true);
                                    return true;
                                }
                                if (p == null) {
                                    Help.sendMsg(null, "You must specify a player if using this command from the command line.", true);
                                    return true;
                                }
                                Help.sendMsg(p, "\u00a7eYour current ping is \u00a7b" + Integer.toString(VCon.a.getPing(p)) + "\u00a7ems", true);
                                return true;
                            }
                            if (!(args[0].equalsIgnoreCase("clear") || args[0].equalsIgnoreCase("c") || args[0].equalsIgnoreCase("count"))) {
                                if (!args[0].equalsIgnoreCase("ct")) return false;
                            }
                            if (!LRCommand.hasPerm(p, "lr.clear")) {
                                LRCommand.noPerm(p);
                                return true;
                            }
                            isCount = args[0].equalsIgnoreCase("count") || args[0].equalsIgnoreCase("ct");
                            if (args.length < 2) break block92;
                            if (args[1].equalsIgnoreCase("items") || args[1].equalsIgnoreCase("i")) {
                                World w5;
                                if (args.length == 2) {
                                    int i3 = (Integer)Protocol.run(new CCItems(), new Object[]{isCount}).getData()[0];
                                    Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i3 == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance(Locale.US).format(i3) + (i3 == 1 ? " item" : " items") + " on the ground between all worlds.", true);
                                    return true;
                                }
                                try {
                                    w5 = Bukkit.getWorld((String)args[2]);
                                }
                                catch (Exception e) {
                                    w5 = null;
                                }
                                if (w5 == null) {
                                    Help.sendMsg(p, "\u00a7cWorld \"" + args[2] + "\" was not found.", true);
                                    return true;
                                }
                                int i4 = (Integer)Protocol.run(new CCItems(), new Object[]{isCount, w5}).getData()[0];
                                Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i4 == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance(Locale.US).format(i4) + (i4 == 1 ? " item" : " items") + " in world \"" + w5.getName() + "\"", true);
                                return true;
                            }
                            if (!args[1].equalsIgnoreCase("entities") && !args[1].equalsIgnoreCase("e")) break block93;
                            if (args.length <= 2) break block94;
                            if (args[2].equalsIgnoreCase("hostile") || args[2].equalsIgnoreCase("h")) {
                                ents = CCEntities.hostile;
                                break block90;
                            } else if (args[2].equalsIgnoreCase("peaceful") || args[2].equalsIgnoreCase("p")) {
                                ents = CCEntities.peaceful;
                                break block90;
                            } else {
                                if (!args[2].equalsIgnoreCase("all") && !args[2].equalsIgnoreCase("a")) {
                                    Help.sendMsg(p, "\u00a7c" + args[2] + " is an invalid entity generality. Valid generalities are hostile, peaceful, or all.", true);
                                    return true;
                                }
                                ents = null;
                            }
                            break block90;
                        }
                        Help.sendMsg(p, "\u00a7cCorrect usage: /lr " + (isCount ? "count(ct)" : "clear(c)") + " entities(e) [hostile(h):peaceful(p):all(a)] <world>", true);
                        return true;
                    }
                    if (args.length == 3) {
                        int i5 = (Integer)Protocol.run(new CCEntities(), new Object[]{isCount, ents}).getData()[0];
                        Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i5 == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance(Locale.US).format(i5) + (i5 == 1 ? " entity" : " entities") + " between all worlds.", true);
                        return true;
                    }
                    if (args.length == 4) {
                        World w6;
                        try {
                            w6 = Bukkit.getWorld((String)args[3]);
                        }
                        catch (Exception e) {
                            w6 = null;
                        }
                        if (w6 == null) {
                            Help.sendMsg(p, "\u00a7cWorld \"" + args[3] + "\" was not found.", true);
                            return true;
                        }
                        int i6 = (Integer)Protocol.run(new CCEntities(), new Object[]{isCount, ents, w6}).getData()[0];
                        Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i6 == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance(Locale.US).format(i6) + (i6 == 1 ? " entity" : " entities") + " from world \"" + w6.getName() + "\"", true);
                        return true;
                    }
                    Help.sendMsg(p, "\u00a7cCorrect usage: /lr " + (isCount ? "count(ct)" : "clear(c)") + " entities(e) [hostile(h):peaceful(p):all(a)] <world>", true);
                    return true;
                }
                if (args[1].equalsIgnoreCase("type") || args[1].equalsIgnoreCase("t")) {
                    if (args.length >= 3) {
                        if (args[2].equalsIgnoreCase("list") || args[2].equalsIgnoreCase("l")) {
                            EntityType[] allEnt;
                            StringBuilder sb = new StringBuilder();
                            for (EntityType pe : allEnt = EntityType.values()) {
                                sb.append(pe.name());
                                sb.append("\u00a77, \u00a7a");
                            }
                            String sbs = sb.toString();
                            if (!sbs.equals("")) {
                                sbs = sbs.substring(0, sbs.length() - 2);
                            }
                            Help.sendMsg(p, "\u00a7eEntity Types (" + Integer.toString(allEnt.length) + "): \u00a7a" + sbs, true);
                            return true;
                        }
                        if (args.length < 4) {
                            Help.sendMsg(p, "\u00a7cPlease list entity types to work with if you are not using the list(l) sub-command. Ex: SNOWBALL FIREWORK", true);
                            return true;
                        }
                        types = new ArrayList<EntityType>();
                        break block91;
                    } else {
                        Help.sendMsg(p, "\u00a7cCorrect usage: /lr " + (isCount ? "count(ct)" : "clear(c)") + " type(t) [list(l):none(n):<world>] <none:types>", true);
                        return true;
                    }
                }
            }
            Help.sendMsg(p, "\u00a7cCorrect usage: /lr " + (isCount ? "count(ct)" : "clear(c)") + " [items(i):entities(e):type(t)] <options>", true);
            return true;
        }
        for (i = 3; i < args.length; ++i) {
            EntityType var;
            try {
                var = EntityType.valueOf((String)args[i].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Help.sendMsg(p, "\u00a7c" + args[i] + " is an invalid entity type. Please use /lr " + (isCount ? "count(ct)" : "clear(c)") + " type(t) list(l)", true);
                return true;
            }
            types.add(var);
        }
        EntityType[] ents = types.toArray(new EntityType[types.size()]);
        if (args[2].equalsIgnoreCase("none") || args[2].equalsIgnoreCase("n")) {
            i = (Integer)Protocol.run(new CCEntities(), new Object[]{isCount, ents}).getData()[0];
            Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance().format(i) + (i == 1 ? " entity" : " entities") + " by the " + (ents.length == 1 ? "type" : "types") + " provided.", true);
            return true;
        }
        try {
            w = Bukkit.getWorld((String)args[2]);
        }
        catch (Exception e) {
            w = null;
        }
        if (w == null) {
            Help.sendMsg(p, "\u00a7cWorld \"" + args[2] + "\" was not found.", true);
            return true;
        }
        int i7 = (Integer)Protocol.run(new CCEntities(), new Object[]{isCount, ents, w}).getData()[0];
        Help.sendMsg(p, (isCount ? "\u00a7eThere " + (i7 == 1 ? "is " : "are ") : "\u00a7eRemoved ") + NumberFormat.getNumberInstance().format(i7) + (i7 == 1 ? " entity" : " entities") + " by the " + (ents.length == 1 ? "type" : "types") + " provided in world " + w.getName() + ".", true);
        return true;
    }

    private static boolean hasPerm(Player p, String msg) {
        if (p == null) {
            return true;
        }
        return p.hasPermission(msg);
    }

    private static void noPerm(Player p) {
        Help.sendMsg(p, "\u00a7cYou do not have permission to use this command. Please contact your administrator if you believe this to be an error.", true);
    }
}

