/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.main;

import drew6017.lr.api.proto.DelayedLRProtocolResult;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.api.proto.Protocol;
import drew6017.lr.inf.Help;
import drew6017.lr.main.LaggRemover;
import drew6017.lr.main.TPS;
import drew6017.lr.proto.bin.CCEntities;
import drew6017.lr.util.DoubleVar;
import drew6017.lr.util.LRConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    private static List<UUID> useLocationLagRemoval = new ArrayList<UUID>();
    private static List<UUID> chatDelay = new ArrayList<UUID>();
    private static boolean canSLDRun = true;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldInitEvent e) {
        if (LRConfig.noSpawnChunks) {
            e.getWorld().setKeepSpawnInMemory(false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!p.hasPermission("lr.nochatdelay") && LRConfig.chatDelay > 0) {
            if (chatDelay.contains(uuid)) {
                e.setCancelled(true);
                Help.sendMsg(p, "\u00a7cPlease slow down your chat.", true);
                return;
            }
            this.chatDelayCooldown(uuid);
        }
        if (LRConfig.doRelativeAction && !useLocationLagRemoval.contains(uuid) && e.getMessage().toLowerCase().contains("lag")) {
            List ents;
            if (canSLDRun && LRConfig.isAIActive) {
                this.smartLagDetection();
            }
            if ((ents = p.getNearbyEntities((double)LRConfig.localLagRadius, (double)LRConfig.localLagRadius, (double)LRConfig.localLagRadius)).size() < LRConfig.localLagTriggered) {
                return;
            }
            this.cooldown(uuid);
            int entsLeng = (int)((float)ents.size() * LRConfig.localThinPercent);
            int toRemove = ents.size() - entsLeng;
            for (int i = 0; i < toRemove && !ents.isEmpty(); ++i) {
                ents.remove(0);
            }
            p.sendMessage("\u00a7eEntities around you are being removed because we detected you were lagging.");
            if (LRConfig.doOnlyItemsForRelative) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

                    @Override
                    public void run() {
                        for (Entity en : ents) {
                            if (!en.getType().equals((Object)EntityType.DROPPED_ITEM)) continue;
                            en.remove();
                        }
                    }
                }, 1L);
                return;
            }
            if (LRConfig.dontDoFriendlyMobsForRelative) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

                    @Override
                    public void run() {
                        CCEntities.clearEntities(ents, false, CCEntities.hostile);
                        for (Entity en : ents) {
                            if (!en.getType().equals((Object)EntityType.DROPPED_ITEM)) continue;
                            en.remove();
                        }
                    }
                }, 1L);
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

                @Override
                public void run() {
                    CCEntities.clearEntities(ents, false, CCEntities.hostile);
                    CCEntities.clearEntities(ents, false, CCEntities.peaceful);
                    for (Entity en : ents) {
                        if (!en.getType().equals((Object)EntityType.DROPPED_ITEM)) continue;
                        en.remove();
                    }
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onSpawn(EntitySpawnEvent e) {
        if (LRConfig.thinMobs && e.getLocation().getChunk().getEntities().length > LRConfig.thinAt) {
            e.setCancelled(true);
        }
    }

    private void cooldown(final UUID u) {
        useLocationLagRemoval.add(u);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

            @Override
            public void run() {
                useLocationLagRemoval.remove(u);
            }
        }, (long)(20 * LRConfig.localLagRemovalCooldown));
    }

    private void smartAIcooldown() {
        canSLDRun = false;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

            @Override
            public void run() {
                canSLDRun = true;
            }
        }, 1200L * LRConfig.smartaicooldown);
    }

    private void chatDelayCooldown(final UUID u) {
        chatDelay.add(u);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

            @Override
            public void run() {
                chatDelay.remove(u);
            }
        }, (long)LRConfig.chatDelay);
    }

    private void smartLagDetection() {
        this.smartAIcooldown();
        Runtime r = Runtime.getRuntime();
        long ram_used = (r.totalMemory() - r.freeMemory()) / 1024L / 1024L;
        long ram_total = r.maxMemory() / 1024L / 1024L;
        if (ram_total - ram_used < LRConfig.ramConstant) {
            for (LRProtocol p : LRConfig.ram_protocols.keySet()) {
                DoubleVar<Object[], Boolean> dat = LRConfig.ram_protocols.get(p);
                if (dat.getVar2().booleanValue()) {
                    Protocol.rund(p, dat.getVar1(), new DelayedLRProtocolResult(){

                        @Override
                        public void receive(LRProtocolResult result) {
                        }
                    });
                    continue;
                }
                p.run(dat.getVar1());
            }
            return;
        }
        if (TPS.getTPS() < LRConfig.lagConstant) {
            for (LRProtocol p : LRConfig.tps_protocols.keySet()) {
                DoubleVar<Object[], Boolean> dat = LRConfig.tps_protocols.get(p);
                if (dat.getVar2().booleanValue()) {
                    Protocol.rund(p, dat.getVar1(), new DelayedLRProtocolResult(){

                        @Override
                        public void receive(LRProtocolResult result) {
                        }
                    });
                    continue;
                }
                p.run(dat.getVar1());
            }
            return;
        }
    }
}

