/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.command;

import com.thevoxelbox.voxelsniper.RangeBlockHelper;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.api.command.VoxelCommand;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VoxelInkReplaceCommand
extends VoxelCommand {
    public VoxelInkReplaceCommand(VoxelSniper plugin) {
        super("VoxelInkReplace", plugin);
        this.setIdentifier("vir");
        this.setPermission("voxelsniper.sniper");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onCommand(Player player, String[] args) {
        byte dataValue;
        Sniper sniper = this.plugin.getSniperManager().getSniperForPlayer(player);
        if (args.length == 0) {
            Block targetBlock = new RangeBlockHelper(player, player.getWorld()).getTargetBlock();
            if (targetBlock == null) return true;
            dataValue = targetBlock.getData();
        } else {
            try {
                dataValue = Byte.parseByte(args[0]);
            }
            catch (NumberFormatException exception) {
                player.sendMessage("Couldn't parse input.");
                return true;
            }
        }
        SnipeData snipeData = sniper.getSnipeData(sniper.getCurrentToolId());
        snipeData.setReplaceData(dataValue);
        snipeData.getVoxelMessage().replaceData();
        return true;
    }
}

