/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.bukkit.ChatColor;

public class StencilListBrush
extends Brush {
    private byte pasteOption = 1;
    private String filename = "NoFileLoaded";
    private short x;
    private short z;
    private short y;
    private short xRef;
    private short zRef;
    private short yRef;
    private byte pasteParam = 0;
    private HashMap<Integer, String> stencilList = new HashMap();

    public StencilListBrush() {
        this.setName("StencilList");
    }

    private String readRandomStencil(SnipeData v) {
        double rand = Math.random() * (double)this.stencilList.size();
        int choice = (int)rand;
        return this.stencilList.get(choice);
    }

    private void readStencilList(String listname, SnipeData v) {
        File file = new File("plugins/VoxelSniper/stencilLists/" + this.filename + ".txt");
        if (file.exists()) {
            try {
                Scanner scanner = new Scanner(file);
                int counter = 0;
                while (scanner.hasNext()) {
                    this.stencilList.put(counter, scanner.nextLine());
                    ++counter;
                }
                scanner.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void stencilPaste(SnipeData v) {
        if (this.filename.matches("NoFileLoaded")) {
            v.sendMessage(ChatColor.RED + "You did not specify a filename for the list.  This is required.");
            return;
        }
        String stencilName = this.readRandomStencil(v);
        v.sendMessage(stencilName);
        Undo undo = new Undo();
        File file = new File("plugins/VoxelSniper/stencils/" + stencilName + ".vstencil");
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.x = in.readShort();
                this.z = in.readShort();
                this.y = in.readShort();
                this.xRef = in.readShort();
                this.zRef = in.readShort();
                this.yRef = in.readShort();
                int numRuns = in.readInt();
                int volume = this.x * this.y * this.z;
                v.owner().getPlayer().sendMessage(ChatColor.AQUA + this.filename + " pasted.  Volume is " + volume + " blocks.");
                int currX = -this.xRef;
                int currZ = -this.zRef;
                int currY = -this.yRef;
                if (this.pasteOption == 0) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            int id = in.readByte() + 128;
                            int data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                        this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(in.readByte() + 128, (byte)(in.readByte() + 128), false);
                        if (++currX != this.x - this.xRef) continue;
                        currX = -this.xRef;
                        if (++currZ != this.z - this.zRef) continue;
                        currZ = -this.zRef;
                        ++currY;
                    }
                } else if (this.pasteOption == 1) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currX != this.x - this.xRef) continue;
                        currX = -this.xRef;
                        if (++currZ != this.z - this.zRef) continue;
                        currZ = -this.zRef;
                        ++currY;
                    }
                } else {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currX != this.x) continue;
                        currX = 0;
                        if (++currZ != this.z) continue;
                        currZ = 0;
                        ++currY;
                    }
                }
                in.close();
                v.owner().storeUndo(undo);
            }
            catch (Exception exception) {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
                exception.printStackTrace();
            }
        } else {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You need to type a stencil name / your specified stencil does not exist.");
        }
    }

    private void stencilPaste180(SnipeData v) {
        if (this.filename.matches("NoFileLoaded")) {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You did not specify a filename for the list.  This is required.");
            return;
        }
        String stencilName = this.readRandomStencil(v);
        Undo undo = new Undo();
        File file = new File("plugins/VoxelSniper/stencils/" + stencilName + ".vstencil");
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.x = in.readShort();
                this.z = in.readShort();
                this.y = in.readShort();
                this.xRef = in.readShort();
                this.zRef = in.readShort();
                this.yRef = in.readShort();
                int numRuns = in.readInt();
                int volume = this.x * this.y * this.z;
                v.owner().getPlayer().sendMessage(ChatColor.AQUA + this.filename + " pasted.  Volume is " + volume + " blocks.");
                int currX = this.xRef;
                int currZ = this.zRef;
                int currY = -this.yRef;
                if (this.pasteOption == 0) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            int id = in.readByte() + 128;
                            int data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                if (--currX != -this.x + this.xRef) continue;
                                currX = this.xRef;
                                if (--currZ != -this.z + this.zRef) continue;
                                currZ = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                        this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(in.readByte() + 128, (byte)(in.readByte() + 128), false);
                        if (--currX != -this.x + this.xRef) continue;
                        currX = this.xRef;
                        if (--currZ != -this.z + this.zRef) continue;
                        currZ = this.zRef;
                        ++currY;
                    }
                } else if (this.pasteOption == 1) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (--currX != -this.x + this.xRef) continue;
                                currX = this.xRef;
                                if (--currZ != -this.z + this.zRef) continue;
                                currZ = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (--currX != -this.x + this.xRef) continue;
                        currX = this.xRef;
                        if (--currZ != -this.z + this.zRef) continue;
                        currZ = this.zRef;
                        ++currY;
                    }
                } else {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (--currX != -this.x + this.xRef) continue;
                                currX = this.xRef;
                                if (--currZ != -this.z + this.zRef) continue;
                                currZ = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (--currX != -this.x + this.xRef) continue;
                        currX = this.xRef;
                        if (--currZ != -this.z + this.zRef) continue;
                        currZ = this.zRef;
                        ++currY;
                    }
                }
                in.close();
                v.owner().storeUndo(undo);
            }
            catch (Exception exception) {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
                exception.printStackTrace();
            }
        } else {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You need to type a stencil name / your specified stencil does not exist.");
        }
    }

    private void stencilPaste270(SnipeData v) {
        if (this.filename.matches("NoFileLoaded")) {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You did not specify a filename for the list.  This is required.");
            return;
        }
        String stencilName = this.readRandomStencil(v);
        Undo undo = new Undo();
        File file = new File("plugins/VoxelSniper/stencils/" + stencilName + ".vstencil");
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.x = in.readShort();
                this.z = in.readShort();
                this.y = in.readShort();
                this.xRef = in.readShort();
                this.zRef = in.readShort();
                this.yRef = in.readShort();
                int numRuns = in.readInt();
                int volume = this.x * this.y * this.z;
                v.owner().getPlayer().sendMessage(ChatColor.AQUA + this.filename + " pasted.  Volume is " + volume + " blocks.");
                int currX = this.zRef;
                int currZ = -this.xRef;
                int currY = -this.yRef;
                if (this.pasteOption == 0) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            int id = in.readByte() + 128;
                            int data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                if (++currZ != this.x - this.xRef) continue;
                                currZ = -this.xRef;
                                if (--currX != -this.z + this.zRef) continue;
                                currX = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                        this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(in.readByte() + 128, (byte)(in.readByte() + 128), false);
                        ++currZ;
                        if (++currZ != this.x - this.xRef) continue;
                        currZ = -this.xRef;
                        if (--currX != -this.z + this.zRef) continue;
                        currX = this.zRef;
                        ++currY;
                    }
                } else if (this.pasteOption == 1) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currZ != this.x - this.xRef) continue;
                                currZ = -this.xRef;
                                if (--currX != -this.z + this.zRef) continue;
                                currX = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currZ != this.x - this.xRef) continue;
                        currZ = -this.xRef;
                        if (--currX != -this.z + this.zRef) continue;
                        currX = this.zRef;
                        ++currY;
                    }
                } else {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currZ != this.x - this.xRef) continue;
                                currZ = -this.xRef;
                                if (--currX != -this.z + this.zRef) continue;
                                currX = this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currZ != this.x - this.xRef) continue;
                        currZ = -this.xRef;
                        if (--currX != -this.z + this.zRef) continue;
                        currX = this.zRef;
                        ++currY;
                    }
                }
                in.close();
                v.owner().storeUndo(undo);
            }
            catch (Exception exception) {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
                exception.printStackTrace();
            }
        } else {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You need to type a stencil name / your specified stencil does not exist.");
        }
    }

    private void stencilPaste90(SnipeData v) {
        if (this.filename.matches("NoFileLoaded")) {
            v.sendMessage(ChatColor.RED + "You did not specify a filename for the list.  This is required.");
            return;
        }
        String stencilName = this.readRandomStencil(v);
        Undo undo = new Undo();
        File file = new File("plugins/VoxelSniper/stencils/" + stencilName + ".vstencil");
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.x = in.readShort();
                this.z = in.readShort();
                this.y = in.readShort();
                this.xRef = in.readShort();
                this.zRef = in.readShort();
                this.yRef = in.readShort();
                int numRuns = in.readInt();
                int volume = this.x * this.y * this.z;
                v.sendMessage(ChatColor.AQUA + this.filename + " pasted.  Volume is " + volume + " blocks.");
                int currX = -this.zRef;
                int currZ = this.xRef;
                int currY = -this.yRef;
                if (this.pasteOption == 0) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            int id = in.readByte() + 128;
                            int data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                if (--currZ != -this.x + this.xRef) continue;
                                currZ = this.xRef;
                                if (++currX != this.z - this.zRef) continue;
                                currX = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                        this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(in.readByte() + 128, (byte)(in.readByte() + 128), false);
                        if (--currZ != -this.x + this.xRef) continue;
                        currZ = this.xRef;
                        if (++currX != this.z - this.zRef) continue;
                        currX = -this.zRef;
                        ++currY;
                    }
                } else if (this.pasteOption == 1) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (--currZ != -this.x + this.xRef) continue;
                                currZ = this.xRef;
                                if (++currX != this.z - this.zRef) continue;
                                currX = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0 && this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).getTypeId() == 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (--currZ != -this.x + this.xRef) continue;
                        currZ = this.xRef;
                        if (++currX != this.z - this.zRef) continue;
                        currX = -this.zRef;
                        ++currY;
                    }
                } else {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0) {
                                    undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                                    this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (--currZ != -this.x + this.xRef) continue;
                                currZ = this.xRef;
                                if (++currX != this.z - this.zRef) continue;
                                currX = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0) {
                            undo.put(this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ));
                            this.clampY(this.getTargetBlock().getX() + currX, this.getTargetBlock().getY() + currY, this.getTargetBlock().getZ() + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (--currZ != -this.x + this.xRef) continue;
                        currZ = this.xRef;
                        if (++currX != this.z - this.zRef) continue;
                        currX = -this.zRef;
                        ++currY;
                    }
                }
                in.close();
                v.owner().storeUndo(undo);
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + "Something went wrong.");
                exception.printStackTrace();
            }
        } else {
            v.owner().getPlayer().sendMessage(ChatColor.RED + "You need to type a stencil name / your specified stencil does not exist.");
        }
    }

    private void stencilPasteRotation(SnipeData v) {
        this.readStencilList(this.filename, v);
        double random = Math.random();
        if (random < 0.26) {
            this.stencilPaste(v);
        } else if (random < 0.51) {
            this.stencilPaste90(v);
        } else if (random < 0.76) {
            this.stencilPaste180(v);
        } else {
            this.stencilPaste270(v);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.stencilPaste(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.stencilPasteRotation(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom("File loaded: " + this.filename);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Stencil List brush Parameters:");
            v.sendMessage(ChatColor.AQUA + "/b schem [optional: 'full' 'fill' or 'replace', with fill as default] [name] -- Loads the specified stencil list.  Full/fill/replace must come first.  Full = paste all blocks, fill = paste only into air blocks, replace = paste full blocks in only, but replace anything in their way.");
            return;
        }
        if (par[1].equalsIgnoreCase("full")) {
            this.pasteOption = 0;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("fill")) {
            this.pasteOption = 1;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("replace")) {
            this.pasteOption = (byte)2;
            this.pasteParam = 1;
        }
        try {
            this.filename = par[1 + this.pasteParam];
            File file = new File("plugins/VoxelSniper/stencilLists/" + this.filename + ".txt");
            if (file.exists()) {
                v.sendMessage(ChatColor.RED + "Stencil List '" + this.filename + "' exists and was loaded.");
                this.readStencilList(this.filename, v);
            } else {
                v.sendMessage(ChatColor.AQUA + "Stencil List '" + this.filename + "' does not exist.  This brush will not function without a valid stencil list.");
                this.filename = "NoFileLoaded";
            }
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "You need to type a stencil name.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.stencillist";
    }
}

