/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class StampBrush
extends Brush {
    protected HashSet<BlockWrapper> clone = new HashSet();
    protected HashSet<BlockWrapper> fall = new HashSet();
    protected HashSet<BlockWrapper> drop = new HashSet();
    protected HashSet<BlockWrapper> solid = new HashSet();
    protected Undo undo;
    protected boolean sorted = false;
    protected StampType stamp = StampType.DEFAULT;

    public StampBrush() {
        this.setName("Stamp");
    }

    public final void reSort() {
        this.sorted = false;
    }

    protected final boolean falling(int id) {
        return id > 7 && id < 14;
    }

    protected final boolean fallsOff(int id) {
        switch (id) {
            default: 
        }
        return false;
    }

    protected final void setBlock(BlockWrapper cb) {
        Block block = this.clampY(this.getTargetBlock().getX() + cb.x, this.getTargetBlock().getY() + cb.y, this.getTargetBlock().getZ() + cb.z);
        this.undo.put(block);
        block.setTypeId(cb.id);
        block.setData(cb.d);
    }

    protected final void setBlockFill(BlockWrapper cb) {
        Block block = this.clampY(this.getTargetBlock().getX() + cb.x, this.getTargetBlock().getY() + cb.y, this.getTargetBlock().getZ() + cb.z);
        if (block.getTypeId() == 0) {
            this.undo.put(block);
            block.setTypeId(cb.id);
            block.setData(cb.d);
        }
    }

    protected final void setStamp(StampType type) {
        this.stamp = type;
    }

    protected final void stamp(SnipeData v) {
        this.undo = new Undo();
        if (this.sorted) {
            for (BlockWrapper block : this.solid) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlock(block);
            }
        } else {
            this.fall.clear();
            this.drop.clear();
            this.solid.clear();
            for (BlockWrapper block : this.clone) {
                if (this.fallsOff(block.id)) {
                    this.fall.add(block);
                    continue;
                }
                if (this.falling(block.id)) {
                    this.drop.add(block);
                    continue;
                }
                this.solid.add(block);
                this.setBlock(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlock(block);
            }
            this.sorted = true;
        }
        v.owner().storeUndo(this.undo);
    }

    protected final void stampFill(SnipeData v) {
        this.undo = new Undo();
        if (this.sorted) {
            for (BlockWrapper block : this.solid) {
                this.setBlockFill(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlockFill(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlockFill(block);
            }
        } else {
            this.fall.clear();
            this.drop.clear();
            this.solid.clear();
            for (BlockWrapper block : this.clone) {
                if (this.fallsOff(block.id)) {
                    this.fall.add(block);
                    continue;
                }
                if (this.falling(block.id)) {
                    this.drop.add(block);
                    continue;
                }
                if (block.id == 0) continue;
                this.solid.add(block);
                this.setBlockFill(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlockFill(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlockFill(block);
            }
            this.sorted = true;
        }
        v.owner().storeUndo(this.undo);
    }

    protected final void stampNoAir(SnipeData v) {
        this.undo = new Undo();
        if (this.sorted) {
            for (BlockWrapper block : this.solid) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlock(block);
            }
        } else {
            this.fall.clear();
            this.drop.clear();
            this.solid.clear();
            for (BlockWrapper block : this.clone) {
                if (this.fallsOff(block.id)) {
                    this.fall.add(block);
                    continue;
                }
                if (this.falling(block.id)) {
                    this.drop.add(block);
                    continue;
                }
                if (block.id == 0) continue;
                this.solid.add(block);
                this.setBlock(block);
            }
            for (BlockWrapper block : this.drop) {
                this.setBlock(block);
            }
            for (BlockWrapper block : this.fall) {
                this.setBlock(block);
            }
            this.sorted = true;
        }
        v.owner().storeUndo(this.undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        switch (this.stamp) {
            case DEFAULT: {
                this.stamp(v);
                break;
            }
            case NO_AIR: {
                this.stampNoAir(v);
                break;
            }
            case FILL: {
                this.stampFill(v);
                break;
            }
            default: {
                v.sendMessage(ChatColor.DARK_RED + "Error while stamping! Report");
            }
        }
    }

    @Override
    protected void powder(SnipeData v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void info(Message vm) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.stamp";
    }

    protected static enum StampType {
        NO_AIR,
        FILL,
        DEFAULT;

    }

    protected class BlockWrapper {
        public int id;
        public int x;
        public int y;
        public int z;
        public byte d;

        public BlockWrapper(Block b, int blx, int bly, int blz) {
            this.id = b.getTypeId();
            this.d = b.getData();
            this.x = blx;
            this.y = bly;
            this.z = blz;
        }
    }
}

