/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class SnowConeBrush
extends Brush {
    private void addSnow(SnipeData v, Block targetBlock) {
        int x;
        int blockPositionZ;
        int blockPositionY;
        int blockPositionX = targetBlock.getX();
        int brushSize = this.getBlockIdAt(blockPositionX, blockPositionY = targetBlock.getY(), blockPositionZ = targetBlock.getZ()) == Material.AIR.getId() ? 0 : this.clampY(blockPositionX, blockPositionY, blockPositionZ).getData() + 1;
        int brushSizeDoubled = 2 * brushSize;
        int[][] snowcone = new int[brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][] snowconeData = new int[brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][] yOffset = new int[brushSizeDoubled + 1][brushSizeDoubled + 1];
        for (x = 0; x <= brushSizeDoubled; ++x) {
            for (int z = 0; z <= brushSizeDoubled; ++z) {
                boolean flag = true;
                for (int i = 0; i < 10; ++i) {
                    if (!flag || this.getBlockIdAt(blockPositionX - brushSize + x, blockPositionY - i, blockPositionZ - brushSize + z) != 0 && this.getBlockIdAt(blockPositionX - brushSize + x, blockPositionY - i, blockPositionZ - brushSize + z) != Material.SNOW.getId() || this.getBlockIdAt(blockPositionX - brushSize + x, blockPositionY - i - 1, blockPositionZ - brushSize + z) == Material.AIR.getId() || this.getBlockIdAt(blockPositionX - brushSize + x, blockPositionY - i - 1, blockPositionZ - brushSize + z) == Material.SNOW.getId()) continue;
                    flag = false;
                    yOffset[x][z] = i;
                }
                snowcone[x][z] = this.getBlockIdAt(blockPositionX - brushSize + x, blockPositionY - yOffset[x][z], blockPositionZ - brushSize + z);
                snowconeData[x][z] = this.clampY(blockPositionX - brushSize + x, blockPositionY - yOffset[x][z], blockPositionZ - brushSize + z).getData();
            }
        }
        for (x = 0; x <= brushSizeDoubled; ++x) {
            double xSquared = Math.pow(x - brushSize, 2.0);
            block12: for (int z = 0; z <= 2 * brushSize; ++z) {
                double zSquared = Math.pow(z - brushSize, 2.0);
                double dist = Math.pow(xSquared + zSquared, 0.5);
                int snowData = brushSize - (int)Math.ceil(dist);
                if (snowData < 0) continue;
                switch (snowData) {
                    case 0: {
                        if (snowcone[x][z] != Material.AIR.getId()) continue block12;
                        snowcone[x][z] = Material.SNOW.getId();
                        snowconeData[x][z] = 0;
                        continue block12;
                    }
                    case 7: {
                        if (snowcone[x][z] != Material.SNOW.getId()) continue block12;
                        snowcone[x][z] = Material.SNOW_BLOCK.getId();
                        snowconeData[x][z] = 0;
                        continue block12;
                    }
                    default: {
                        if (snowData > snowconeData[x][z]) {
                            switch (snowcone[x][z]) {
                                case 0: {
                                    snowconeData[x][z] = snowData;
                                    snowcone[x][z] = Material.SNOW.getId();
                                }
                                case 78: {
                                    snowconeData[x][z] = snowData;
                                    continue block12;
                                }
                            }
                            continue block12;
                        }
                        if (yOffset[x][z] <= 0 || snowcone[x][z] != Material.SNOW.getId()) continue block12;
                        int[] nArray = snowconeData[x];
                        int n = z;
                        nArray[n] = nArray[n] + 1;
                        if (snowconeData[x][z] != 7) continue block12;
                        snowconeData[x][z] = 0;
                        snowcone[x][z] = Material.SNOW_BLOCK.getId();
                    }
                }
            }
        }
        Undo undo = new Undo();
        for (int x2 = 0; x2 <= brushSizeDoubled; ++x2) {
            for (int z = 0; z <= brushSizeDoubled; ++z) {
                if (this.getBlockIdAt(blockPositionX - brushSize + x2, blockPositionY - yOffset[x2][z], blockPositionZ - brushSize + z) != snowcone[x2][z] || this.clampY(blockPositionX - brushSize + x2, blockPositionY - yOffset[x2][z], blockPositionZ - brushSize + z).getData() != snowconeData[x2][z]) {
                    undo.put(this.clampY(blockPositionX - brushSize + x2, blockPositionY - yOffset[x2][z], blockPositionZ - brushSize + z));
                }
                this.setBlockIdAt(blockPositionZ - brushSize + z, blockPositionX - brushSize + x2, blockPositionY - yOffset[x2][z], snowcone[x2][z]);
                this.clampY(blockPositionX - brushSize + x2, blockPositionY - yOffset[x2][z], blockPositionZ - brushSize + z).setData((byte)snowconeData[x2][z]);
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
    }

    @Override
    protected final void powder(SnipeData v) {
        switch (this.getTargetBlock().getType()) {
            case SNOW: {
                this.addSnow(v, this.getTargetBlock());
                break;
            }
            default: {
                Block blockAbove = this.getTargetBlock().getRelative(BlockFace.UP);
                if (blockAbove != null && blockAbove.getType() == Material.AIR) {
                    this.addSnow(v, blockAbove);
                    break;
                }
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Error: Center block neither snow nor air.");
            }
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Snow Cone");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Snow Cone Parameters:");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.snowcone";
    }
}

