/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class ScannerBrush
extends Brush {
    private static final int DEPTH_MIN = 1;
    private static final int DEPTH_DEFAULT = 24;
    private static final int DEPTH_MAX = 64;
    private int depth = 24;
    private Material checkFor = Material.AIR;

    public ScannerBrush() {
        this.setName("Scanner");
    }

    private int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private void scan(SnipeData v, BlockFace bf) {
        if (bf == null) {
            return;
        }
        switch (bf) {
            case NORTH: {
                for (int i = 1; i < this.depth + 1; ++i) {
                    if (this.clampY(this.getTargetBlock().getX() + i, this.getTargetBlock().getY(), this.getTargetBlock().getZ()).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
            case SOUTH: {
                for (int i = 1; i < this.depth + 1; ++i) {
                    if (this.clampY(this.getTargetBlock().getX() - i, this.getTargetBlock().getY(), this.getTargetBlock().getZ()).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
            case EAST: {
                for (int i = 1; i < this.depth + 1; ++i) {
                    if (this.clampY(this.getTargetBlock().getX(), this.getTargetBlock().getY(), this.getTargetBlock().getZ() + i).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
            case WEST: {
                for (int i = 1; i < this.depth + 1; ++i) {
                    if (this.clampY(this.getTargetBlock().getX(), this.getTargetBlock().getY(), this.getTargetBlock().getZ() - i).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
            case UP: {
                for (int i = 1; i < this.depth + 1 && this.getTargetBlock().getY() - i > 0; ++i) {
                    if (this.clampY(this.getTargetBlock().getX(), this.getTargetBlock().getY() - i, this.getTargetBlock().getZ()).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
            case DOWN: {
                for (int i = 1; i < this.depth + 1 && this.getTargetBlock().getY() + i < v.getWorld().getMaxHeight(); ++i) {
                    if (this.clampY(this.getTargetBlock().getX(), this.getTargetBlock().getY() + i, this.getTargetBlock().getZ()).getType() != this.checkFor) continue;
                    v.sendMessage(ChatColor.GREEN + "" + this.checkFor + " found after " + i + " blocks.");
                    return;
                }
                v.sendMessage(ChatColor.GRAY + "Nope.");
                break;
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.checkFor = Material.getMaterial((int)v.getVoxelId());
        this.scan(v, this.getTargetBlock().getFace(this.getLastBlock()));
    }

    @Override
    protected final void powder(SnipeData v) {
        this.checkFor = Material.getMaterial((int)v.getVoxelId());
        this.scan(v, this.getTargetBlock().getFace(this.getLastBlock()));
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GREEN + "Scanner depth set to " + this.depth);
        vm.custom(ChatColor.GREEN + "Scanner scans for " + this.checkFor + " (change with /v #)");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Scanner brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b sc d# -- will set the search depth to #. Clamps to 1 - 64.");
                return;
            }
            if (par[i].startsWith("d")) {
                this.depth = this.clamp(Integer.parseInt(par[i].substring(1)), 1, 64);
                v.sendMessage(ChatColor.AQUA + "Scanner depth set to " + this.depth);
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.scanner";
    }
}

