/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class RingBrush
extends PerformBrush {
    private double trueCircle = 0.0;
    private double innerSize = 0.0;

    public RingBrush() {
        this.setName("Ring");
    }

    private void ring(SnipeData v, Block targetBlock) {
        int brushSize = v.getBrushSize();
        double outerSquared = Math.pow((double)brushSize + this.trueCircle, 2.0);
        double innerSquared = Math.pow(this.innerSize, 2.0);
        for (int x = brushSize; x >= 0; --x) {
            double xSquared = Math.pow(x, 2.0);
            for (int z = brushSize; z >= 0; --z) {
                double ySquared = Math.pow(z, 2.0);
                if (!(xSquared + ySquared <= outerSquared) || !(xSquared + ySquared >= innerSquared)) continue;
                this.current.perform(targetBlock.getRelative(x, 0, z));
                this.current.perform(targetBlock.getRelative(x, 0, -z));
                this.current.perform(targetBlock.getRelative(-x, 0, z));
                this.current.perform(targetBlock.getRelative(-x, 0, -z));
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.ring(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.ring(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.AQUA + "The inner radius is " + ChatColor.RED + this.innerSize);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Ring Brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b ri true -- will use a true circle algorithm instead of the skinnier version with classic sniper nubs. /b ri false will switch back. (false is default)");
                v.sendMessage(ChatColor.AQUA + "/b ri ir2.5 -- will set the inner radius to 2.5 units");
                return;
            }
            if (par[i].startsWith("true")) {
                this.trueCircle = 0.5;
                v.sendMessage(ChatColor.AQUA + "True circle mode ON.");
                continue;
            }
            if (par[i].startsWith("false")) {
                this.trueCircle = 0.0;
                v.sendMessage(ChatColor.AQUA + "True circle mode OFF.");
                continue;
            }
            if (par[i].startsWith("ir")) {
                try {
                    double d;
                    this.innerSize = d = Double.parseDouble(par[i].replace("ir", ""));
                    v.sendMessage(ChatColor.AQUA + "The inner radius has been set to " + ChatColor.RED + this.innerSize);
                }
                catch (Exception exception) {
                    v.sendMessage(ChatColor.RED + "The parameters included are invalid.");
                }
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ring";
    }
}

