/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.Random;
import org.bukkit.block.Block;

public class RandomErodeBrush
extends Brush {
    private final double trueCircle = 0.5;
    private BlockWrapper[][][] snap;
    private BlockWrapper[][][] firstSnap;
    private int bsize;
    private int erodeFace;
    private int fillFace;
    private int brushSize;
    private int erodeRecursion = 1;
    private int fillRecursion = 1;
    private Random generator = new Random();

    public RandomErodeBrush() {
        this.setName("RandomErode");
    }

    private boolean erode(int x, int y, int z) {
        if (this.snap[x][y][z].isSolid()) {
            int d = 0;
            if (!this.snap[x + 1][y][z].isSolid()) {
                ++d;
            }
            if (!this.snap[x - 1][y][z].isSolid()) {
                ++d;
            }
            if (!this.snap[x][y + 1][z].isSolid()) {
                ++d;
            }
            if (!this.snap[x][y - 1][z].isSolid()) {
                ++d;
            }
            if (!this.snap[x][y][z + 1].isSolid()) {
                ++d;
            }
            if (!this.snap[x][y][z - 1].isSolid()) {
                ++d;
            }
            return d >= this.erodeFace;
        }
        return false;
    }

    private boolean fill(int x, int y, int z) {
        if (this.snap[x][y][z].isSolid()) {
            return false;
        }
        int d = 0;
        if (this.snap[x + 1][y][z].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x + 1][y][z].getNativeBlock().getTypeId());
            ++d;
        }
        if (this.snap[x - 1][y][z].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x - 1][y][z].getNativeBlock().getTypeId());
            ++d;
        }
        if (this.snap[x][y + 1][z].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x][y + 1][z].getNativeBlock().getTypeId());
            ++d;
        }
        if (this.snap[x][y - 1][z].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x][y - 1][z].getNativeBlock().getTypeId());
            ++d;
        }
        if (this.snap[x][y][z + 1].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x][y][z + 1].getNativeBlock().getTypeId());
            ++d;
        }
        if (this.snap[x][y][z - 1].isSolid()) {
            this.snap[x][y][z].setId(this.snap[x][y][z - 1].getNativeBlock().getTypeId());
            ++d;
        }
        return d >= this.fillFace;
    }

    private void getMatrix() {
        this.brushSize = (this.bsize + 1) * 2 + 1;
        if (this.snap.length == 0) {
            this.snap = new BlockWrapper[this.brushSize][this.brushSize][this.brushSize];
            int sx = this.getTargetBlock().getX() - (this.bsize + 1);
            int sy = this.getTargetBlock().getY() - (this.bsize + 1);
            int sz = this.getTargetBlock().getZ() - (this.bsize + 1);
            for (int x = 0; x < this.snap.length; ++x) {
                sz = this.getTargetBlock().getZ() - (this.bsize + 1);
                for (int z = 0; z < this.snap.length; ++z) {
                    sy = this.getTargetBlock().getY() - (this.bsize + 1);
                    for (int y = 0; y < this.snap.length; ++y) {
                        this.snap[x][y][z] = new BlockWrapper(this.clampY(sx, sy, sz));
                        ++sy;
                    }
                    ++sz;
                }
                ++sx;
            }
            this.firstSnap = (BlockWrapper[][][])this.snap.clone();
        } else {
            this.snap = new BlockWrapper[this.brushSize][this.brushSize][this.brushSize];
            int sx = this.getTargetBlock().getX() - (this.bsize + 1);
            int sy = this.getTargetBlock().getY() - (this.bsize + 1);
            int sz = this.getTargetBlock().getZ() - (this.bsize + 1);
            for (int x = 0; x < this.snap.length; ++x) {
                sz = this.getTargetBlock().getZ() - (this.bsize + 1);
                for (int z = 0; z < this.snap.length; ++z) {
                    sy = this.getTargetBlock().getY() - (this.bsize + 1);
                    for (int y = 0; y < this.snap.length; ++y) {
                        this.snap[x][y][z] = new BlockWrapper(this.clampY(sx, sy, sz));
                        ++sy;
                    }
                    ++sz;
                }
                ++sx;
            }
        }
    }

    private void rerosion(SnipeData v) {
        int y;
        double xSquared;
        int x;
        double zSquared;
        int z;
        Undo undo = new Undo();
        if (this.erodeFace >= 0 && this.erodeFace <= 6) {
            for (int currentErodeRecursion = 0; currentErodeRecursion < this.erodeRecursion; ++currentErodeRecursion) {
                this.getMatrix();
                double brushSizeSquared = Math.pow((double)this.bsize + this.trueCircle, 2.0);
                for (z = 1; z < this.snap.length - 1; ++z) {
                    zSquared = Math.pow(z - (this.bsize + 1), 2.0);
                    for (x = 1; x < this.snap.length - 1; ++x) {
                        xSquared = Math.pow(x - (this.bsize + 1), 2.0);
                        for (y = 1; y < this.snap.length - 1; ++y) {
                            if (!(xSquared + Math.pow(y - (this.bsize + 1), 2.0) + zSquared <= brushSizeSquared) || !this.erode(x, y, z)) continue;
                            this.snap[x][y][z].getNativeBlock().setTypeId(0);
                        }
                    }
                }
            }
        }
        if (this.fillFace >= 0 && this.fillFace <= 6) {
            double brushSizeSquared = Math.pow((double)this.bsize + 0.5, 2.0);
            for (int currentFillRecursion = 0; currentFillRecursion < this.fillRecursion; ++currentFillRecursion) {
                this.getMatrix();
                for (z = 1; z < this.snap.length - 1; ++z) {
                    zSquared = Math.pow(z - (this.bsize + 1), 2.0);
                    for (x = 1; x < this.snap.length - 1; ++x) {
                        xSquared = Math.pow(x - (this.bsize + 1), 2.0);
                        for (y = 1; y < this.snap.length - 1; ++y) {
                            if (!(xSquared + Math.pow(y - (this.bsize + 1), 2.0) + zSquared <= brushSizeSquared) || !this.fill(x, y, z)) continue;
                            this.snap[x][y][z].getNativeBlock().setTypeId(this.snap[x][y][z].getId());
                        }
                    }
                }
            }
        }
        BlockWrapper[][][] blockWrapperArray = this.firstSnap;
        int n = blockWrapperArray.length;
        for (int i = 0; i < n; ++i) {
            BlockWrapper[][] firstSnapSlice;
            BlockWrapper[][] blockWrapperArray2 = firstSnapSlice = blockWrapperArray[i];
            int n2 = blockWrapperArray2.length;
            for (int j = 0; j < n2; ++j) {
                BlockWrapper[] firstSnapString;
                for (BlockWrapper block : firstSnapString = blockWrapperArray2[j]) {
                    if (block.getI() == block.getNativeBlock().getTypeId()) continue;
                    undo.put(block.getNativeBlock());
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    private void rfilling(SnipeData v) {
        int y;
        double xSquared;
        int x;
        double zSquared;
        int z;
        double bSquared;
        Undo undo = new Undo();
        if (this.fillFace >= 0 && this.fillFace <= 6) {
            bSquared = Math.pow((double)this.bsize + 0.5, 2.0);
            for (int currentFillRecursion = 0; currentFillRecursion < this.fillRecursion; ++currentFillRecursion) {
                this.getMatrix();
                for (z = 1; z < this.snap.length - 1; ++z) {
                    zSquared = Math.pow(z - (this.bsize + 1), 2.0);
                    for (x = 1; x < this.snap.length - 1; ++x) {
                        xSquared = Math.pow(x - (this.bsize + 1), 2.0);
                        for (y = 1; y < this.snap.length - 1; ++y) {
                            if (!(xSquared + Math.pow(y - (this.bsize + 1), 2.0) + zSquared <= bSquared) || !this.fill(x, y, z)) continue;
                            this.snap[x][y][z].getNativeBlock().setTypeId(this.snap[x][y][z].getId());
                        }
                    }
                }
            }
        }
        if (this.erodeFace >= 0 && this.erodeFace <= 6) {
            bSquared = Math.pow((double)this.bsize + this.trueCircle, 2.0);
            for (int currentErodeRecursion = 0; currentErodeRecursion < this.erodeRecursion; ++currentErodeRecursion) {
                this.getMatrix();
                for (z = 1; z < this.snap.length - 1; ++z) {
                    zSquared = Math.pow(z - (this.bsize + 1), 2.0);
                    for (x = 1; x < this.snap.length - 1; ++x) {
                        xSquared = Math.pow(x - (this.bsize + 1), 2.0);
                        for (y = 1; y < this.snap.length - 1; ++y) {
                            if (!(xSquared + Math.pow(y - (this.bsize + 1), 2.0) + zSquared <= bSquared) || !this.erode(x, y, z)) continue;
                            this.snap[x][y][z].getNativeBlock().setTypeId(0);
                        }
                    }
                }
            }
        }
        BlockWrapper[][][] blockWrapperArray = this.firstSnap;
        int n = blockWrapperArray.length;
        for (int i = 0; i < n; ++i) {
            BlockWrapper[][] firstSnapSlice;
            BlockWrapper[][] blockWrapperArray2 = firstSnapSlice = blockWrapperArray[i];
            int n2 = blockWrapperArray2.length;
            for (int j = 0; j < n2; ++j) {
                BlockWrapper[] firstSnapString;
                for (BlockWrapper block : firstSnapString = blockWrapperArray2[j]) {
                    if (block.getI() == block.getNativeBlock().getTypeId()) continue;
                    undo.put(block.getNativeBlock());
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bsize = v.getBrushSize();
        this.snap = new BlockWrapper[0][0][0];
        this.erodeFace = this.generator.nextInt(5) + 1;
        this.fillFace = this.generator.nextInt(3) + 3;
        this.erodeRecursion = this.generator.nextInt(3);
        this.fillRecursion = this.generator.nextInt(3);
        if (this.fillRecursion == 0 && this.erodeRecursion == 0) {
            this.erodeRecursion = this.generator.nextInt(2) + 1;
            this.fillRecursion = this.generator.nextInt(2) + 1;
        }
        this.rerosion(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bsize = v.getBrushSize();
        this.snap = new BlockWrapper[0][0][0];
        this.erodeFace = this.generator.nextInt(3) + 3;
        this.fillFace = this.generator.nextInt(5) + 1;
        this.erodeRecursion = this.generator.nextInt(3);
        this.fillRecursion = this.generator.nextInt(3);
        if (this.fillRecursion == 0 && this.erodeRecursion == 0) {
            this.erodeRecursion = this.generator.nextInt(2) + 1;
            this.fillRecursion = this.generator.nextInt(2) + 1;
        }
        this.rfilling(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.randomerode";
    }

    private class BlockWrapper {
        private boolean solid;
        private Block nativeBlock;
        private int id;
        private int i;

        public BlockWrapper(Block bl) {
            this.setNativeBlock(bl);
            this.setI(bl.getTypeId());
            switch (bl.getType()) {
                case AIR: {
                    this.setSolid(false);
                    break;
                }
                case WATER: {
                    this.setSolid(false);
                    break;
                }
                case STATIONARY_WATER: {
                    this.setSolid(false);
                    break;
                }
                case STATIONARY_LAVA: {
                    this.setSolid(false);
                    break;
                }
                case LAVA: {
                    this.setSolid(false);
                    break;
                }
                default: {
                    this.setSolid(true);
                }
            }
        }

        public boolean isSolid() {
            return this.solid;
        }

        public void setSolid(boolean solid) {
            this.solid = solid;
        }

        public Block getNativeBlock() {
            return this.nativeBlock;
        }

        public void setNativeBlock(Block nativeBlock) {
            this.nativeBlock = nativeBlock;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }
    }
}

