/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class PullBrush
extends Brush {
    private final HashSet<BlockWrapper> surface = new HashSet();
    private int vh;
    private double c1 = 1.0;
    private double c2 = 0.0;

    public PullBrush() {
        this.setName("Soft Selection");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.height();
        vm.custom(ChatColor.AQUA + "Pinch " + (-this.c1 + 1.0));
        vm.custom(ChatColor.AQUA + "Bubble " + this.c2);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        try {
            double pinch = Double.parseDouble(par[1]);
            double bubble = Double.parseDouble(par[2]);
            this.c1 = 1.0 - pinch;
            this.c2 = bubble;
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "Invalid brush parameters!");
        }
    }

    private double getStr(double t) {
        double lt = 1.0 - t;
        return lt * lt * lt + 3.0 * (lt * lt) * t * this.c1 + 3.0 * lt * (t * t) * this.c2;
    }

    private void getSurface(SnipeData v) {
        this.surface.clear();
        double bSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        for (int z = -v.getBrushSize(); z <= v.getBrushSize(); ++z) {
            double zSquared = Math.pow(z, 2.0);
            int actualZ = this.getTargetBlock().getZ() + z;
            for (int x = -v.getBrushSize(); x <= v.getBrushSize(); ++x) {
                double xSquared = Math.pow(x, 2.0);
                int actualX = this.getTargetBlock().getX() + x;
                for (int y = -v.getBrushSize(); y <= v.getBrushSize(); ++y) {
                    double volume = xSquared + Math.pow(y, 2.0) + zSquared;
                    if (!(volume <= bSquared) || !this.isSurface(actualX, this.getTargetBlock().getY() + y, actualZ)) continue;
                    this.surface.add(new BlockWrapper(this.clampY(actualX, this.getTargetBlock().getY() + y, actualZ), this.getStr(volume / bSquared)));
                }
            }
        }
    }

    private boolean isSurface(int x, int y, int z) {
        return this.getBlockIdAt(x, y, z) != 0 && (this.getBlockIdAt(x, y - 1, z) == 0 || this.getBlockIdAt(x, y + 1, z) == 0 || this.getBlockIdAt(x + 1, y, z) == 0 || this.getBlockIdAt(x - 1, y, z) == 0 || this.getBlockIdAt(x, y, z + 1) == 0 || this.getBlockIdAt(x, y, z - 1) == 0);
    }

    private void setBlock(BlockWrapper block) {
        Block currentBlock = this.clampY(block.getX(), block.getY() + (int)((double)this.vh * block.getStr()), block.getZ());
        if (this.getBlockIdAt(block.getX(), block.getY() - 1, block.getZ()) == 0) {
            currentBlock.setTypeId(block.getId());
            currentBlock.setData(block.getD());
            for (int y = block.getY(); y < currentBlock.getY(); ++y) {
                this.setBlockIdAt(block.getZ(), block.getX(), y, 0);
            }
        } else {
            currentBlock.setTypeId(block.getId());
            currentBlock.setData(block.getD());
            for (int y = block.getY() - 1; y < currentBlock.getY(); ++y) {
                Block current = this.clampY(block.getX(), y, block.getZ());
                current.setTypeId(block.getId());
                current.setData(block.getD());
            }
        }
    }

    private void setBlockDown(BlockWrapper block) {
        Block currentBlock = this.clampY(block.getX(), block.getY() + (int)((double)this.vh * block.getStr()), block.getZ());
        currentBlock.setTypeId(block.getId());
        currentBlock.setData(block.getD());
        for (int y = block.getY(); y > currentBlock.getY(); --y) {
            this.setBlockIdAt(block.getZ(), block.getX(), y, 0);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        block3: {
            block2: {
                this.vh = v.getVoxelHeight();
                this.getSurface(v);
                if (this.vh <= 0) break block2;
                for (BlockWrapper block : this.surface) {
                    this.setBlock(block);
                }
                break block3;
            }
            if (this.vh >= 0) break block3;
            for (BlockWrapper block : this.surface) {
                this.setBlockDown(block);
            }
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.vh = v.getVoxelHeight();
        this.surface.clear();
        double brushSizeSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        if (this.vh > 0) {
            for (int z = -v.getBrushSize(); z <= v.getBrushSize(); ++z) {
                int zSquared = z * z;
                int actualZ = this.getTargetBlock().getZ() + z;
                block1: for (int x = -v.getBrushSize(); x <= v.getBrushSize(); ++x) {
                    int xSquared = x * x;
                    int actualX = this.getTargetBlock().getX() + x;
                    for (int y = v.getBrushSize(); y >= -v.getBrushSize(); --y) {
                        double volume = zSquared + xSquared + y * y;
                        if (!(volume <= brushSizeSquared) || this.getWorld().getBlockTypeIdAt(actualX, this.getTargetBlock().getY() + y, actualZ) == 0) continue;
                        int actualY = this.getTargetBlock().getY() + y;
                        double str = this.getStr(volume / brushSizeSquared);
                        int lastStr = (int)((double)this.vh * str);
                        int lastY = actualY + lastStr;
                        this.clampY(actualX, lastY, actualZ).setTypeId(this.getWorld().getBlockTypeIdAt(actualX, actualY, actualZ));
                        if (str == 1.0) {
                            str = 0.8;
                        }
                        while (lastStr > 0) {
                            if (actualY < this.getTargetBlock().getY()) {
                                str *= str;
                            }
                            lastStr = (int)((double)this.vh * str);
                            int newY = actualY + lastStr;
                            int id = this.getWorld().getBlockTypeIdAt(actualX, actualY, actualZ);
                            for (int i = newY; i < lastY; ++i) {
                                this.clampY(actualX, i, actualZ).setTypeId(id);
                            }
                            lastY = newY;
                            --actualY;
                        }
                        continue block1;
                    }
                }
            }
        } else {
            for (int z = -v.getBrushSize(); z <= v.getBrushSize(); ++z) {
                double zSquared = Math.pow(z, 2.0);
                int actualZ = this.getTargetBlock().getZ() + z;
                block6: for (int x = -v.getBrushSize(); x <= v.getBrushSize(); ++x) {
                    double xSquared = Math.pow(x, 2.0);
                    int actualX = this.getTargetBlock().getX() + x;
                    for (int y = -v.getBrushSize(); y <= v.getBrushSize(); ++y) {
                        double volume = xSquared + Math.pow(y, 2.0) + zSquared;
                        if (!(volume <= brushSizeSquared) || this.getWorld().getBlockTypeIdAt(actualX, this.getTargetBlock().getY() + y, actualZ) == 0) continue;
                        int actualY = this.getTargetBlock().getY() + y;
                        int lastY = actualY + (int)((double)this.vh * this.getStr(volume / brushSizeSquared));
                        this.clampY(actualX, lastY, actualZ).setTypeId(this.getWorld().getBlockTypeIdAt(actualX, actualY, actualZ));
                        volume = xSquared + Math.pow(++y, 2.0) + zSquared;
                        while (volume <= brushSizeSquared) {
                            int blockY = this.getTargetBlock().getY() + y + (int)((double)this.vh * this.getStr(volume / brushSizeSquared));
                            int blockId = this.getWorld().getBlockTypeIdAt(actualX, this.getTargetBlock().getY() + y, actualZ);
                            for (int i = blockY; i < lastY; ++i) {
                                this.clampY(actualX, i, actualZ).setTypeId(blockId);
                            }
                            lastY = blockY;
                            volume = xSquared + Math.pow(++y, 2.0) + zSquared;
                        }
                        continue block6;
                    }
                }
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.pull";
    }

    private final class BlockWrapper {
        private final int id;
        private final byte d;
        private final double str;
        private final int x;
        private final int y;
        private final int z;

        public BlockWrapper(Block block, double st) {
            this.id = block.getTypeId();
            this.d = block.getData();
            this.x = block.getX();
            this.y = block.getY();
            this.z = block.getZ();
            this.str = st;
        }

        public byte getD() {
            return this.d;
        }

        public int getId() {
            return this.id;
        }

        public double getStr() {
            return this.str;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }
    }
}

