/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class OverlayBrush
extends PerformBrush {
    private static final int DEFAULT_DEPTH = 3;
    private int depth = 3;
    private boolean allBlocks = false;

    public OverlayBrush() {
        this.setName("Overlay (Topsoil Filling)");
    }

    private void overlay(SnipeData v) {
        int brushSize = v.getBrushSize();
        double brushSizeSquared = Math.pow((double)brushSize + 0.5, 2.0);
        for (int z = brushSize; z >= -brushSize; --z) {
            block1: for (int x = brushSize; x >= -brushSize; --x) {
                int materialId = this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY() + 1, this.getTargetBlock().getZ() + z);
                if (!this.isIgnoredBlock(materialId) || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared)) continue;
                for (int y = this.getTargetBlock().getY(); y > 0; --y) {
                    int layerBlockId = this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z);
                    if (this.isIgnoredBlock(layerBlockId)) continue;
                    int currentDepth = y;
                    while (y - currentDepth < this.depth) {
                        int currentBlockId = this.getBlockIdAt(this.getTargetBlock().getX() + x, currentDepth, this.getTargetBlock().getZ() + z);
                        if (this.isOverrideableMaterial(currentBlockId)) {
                            this.current.perform(this.clampY(this.getTargetBlock().getX() + x, currentDepth, this.getTargetBlock().getZ() + z));
                        }
                        --currentDepth;
                    }
                    continue block1;
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private boolean isIgnoredBlock(int materialId) {
        return materialId == 9 || materialId == 8 || Material.getMaterial((int)materialId).isTransparent() || materialId == Material.CACTUS.getId();
    }

    private boolean isOverrideableMaterial(int materialId) {
        if (this.allBlocks && materialId != Material.AIR.getId()) {
            return true;
        }
        switch (materialId) {
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 24: 
            case 48: 
            case 49: 
            case 78: 
            case 82: {
                return true;
            }
        }
        return false;
    }

    private void overlayTwo(SnipeData v) {
        int brushSize = v.getBrushSize();
        double brushSizeSquared = Math.pow((double)brushSize + 0.5, 2.0);
        int[][] memory = new int[brushSize * 2 + 1][brushSize * 2 + 1];
        for (int z = brushSize; z >= -brushSize; --z) {
            for (int x = brushSize; x >= -brushSize; --x) {
                boolean surfaceFound = false;
                for (int y = this.getTargetBlock().getY(); y > 0 && !surfaceFound; --y) {
                    int d;
                    if (memory[x + brushSize][z + brushSize] == 1 || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared) || this.getBlockIdAt(this.getTargetBlock().getX() + x, y - 1, this.getTargetBlock().getZ() + z) == 0 || this.getBlockIdAt(this.getTargetBlock().getX() + x, y + 1, this.getTargetBlock().getZ() + z) != 0) continue;
                    if (!this.allBlocks) {
                        switch (this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 24: 
                            case 48: 
                            case 49: 
                            case 78: 
                            case 82: {
                                for (d = 1; d < this.depth + 1; ++d) {
                                    this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z));
                                    memory[x + brushSize][z + brushSize] = 1;
                                }
                                surfaceFound = true;
                                break;
                            }
                        }
                        continue;
                    }
                    for (d = 1; d < this.depth + 1; ++d) {
                        this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z));
                        memory[x + brushSize][z + brushSize] = 1;
                    }
                    surfaceFound = true;
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.overlay(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.overlayTwo(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Overlay brush parameters:");
                v.sendMessage(ChatColor.AQUA + "d[number] (ex:  d3) How many blocks deep you want to replace from the surface.");
                v.sendMessage(ChatColor.BLUE + "all (ex:  /b over all) Sets the brush to overlay over ALL materials, not just natural surface ones (will no longer ignore trees and buildings).  The parameter /some will set it back to default.");
                return;
            }
            if (parameter.startsWith("d")) {
                try {
                    this.depth = Integer.parseInt(parameter.replace("d", ""));
                    if (this.depth < 1) {
                        this.depth = 1;
                    }
                    v.sendMessage(ChatColor.AQUA + "Depth set to " + this.depth);
                }
                catch (NumberFormatException e) {
                    v.sendMessage(ChatColor.RED + "Depth isn't a number.");
                }
                continue;
            }
            if (parameter.startsWith("all")) {
                this.allBlocks = true;
                v.sendMessage(ChatColor.BLUE + "Will overlay over any block." + this.depth);
                continue;
            }
            if (parameter.startsWith("some")) {
                this.allBlocks = false;
                v.sendMessage(ChatColor.BLUE + "Will overlay only natural block types." + this.depth);
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.overlay";
    }
}

