/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;
import org.bukkit.util.noise.PerlinNoiseGenerator;

public class HeatRayBrush
extends Brush {
    private static final double REQUIRED_OBSIDIAN_DENSITY = 0.6;
    private static final double REQUIRED_COBBLE_DENSITY = 0.5;
    private static final double REQUIRED_FIRE_DENSITY = -0.25;
    private static final double REQUIRED_AIR_DENSITY = 0.0;
    private static final ArrayList<Material> FLAMABLE_BLOCKS = new ArrayList();
    private int octaves = 5;
    private double frequency = 1.0;
    private double amplitude = 0.3;

    public HeatRayBrush() {
        this.setName("Heat Ray");
    }

    public final void heatRay(SnipeData v) {
        PerlinNoiseGenerator generator = new PerlinNoiseGenerator(new Random());
        Vector targetLocation = this.getTargetBlock().getLocation().toVector();
        Location currentLocation = new Location(this.getTargetBlock().getWorld(), 0.0, 0.0, 0.0);
        Undo undo = new Undo();
        for (int z = v.getBrushSize(); z >= -v.getBrushSize(); --z) {
            for (int x = v.getBrushSize(); x >= -v.getBrushSize(); --x) {
                for (int y = v.getBrushSize(); y >= -v.getBrushSize(); --y) {
                    Block currentBlock;
                    currentLocation.setX((double)(this.getTargetBlock().getX() + x));
                    currentLocation.setY((double)(this.getTargetBlock().getY() + y));
                    currentLocation.setZ((double)(this.getTargetBlock().getZ() + z));
                    if (!currentLocation.toVector().isInSphere(targetLocation, (double)v.getBrushSize()) || (currentBlock = currentLocation.getBlock()) == null || currentBlock.getType() == Material.CHEST) continue;
                    if (currentBlock.isLiquid()) {
                        undo.put(currentBlock);
                        currentBlock.setType(Material.AIR);
                        continue;
                    }
                    if (FLAMABLE_BLOCKS.contains(currentBlock.getType())) {
                        undo.put(currentBlock);
                        currentBlock.setType(Material.FIRE);
                        continue;
                    }
                    if (currentBlock.getType().equals((Object)Material.AIR)) continue;
                    double airDensity = generator.noise(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ(), this.octaves, this.frequency, this.amplitude);
                    double fireDensity = generator.noise(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ(), this.octaves, this.frequency, this.amplitude);
                    double cobbleDensity = generator.noise(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ(), this.octaves, this.frequency, this.amplitude);
                    double obsidianDensity = generator.noise(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ(), this.octaves, this.frequency, this.amplitude);
                    if (obsidianDensity >= 0.6) {
                        undo.put(currentBlock);
                        if (currentBlock.getType() == Material.OBSIDIAN) continue;
                        currentBlock.setType(Material.OBSIDIAN);
                        continue;
                    }
                    if (cobbleDensity >= 0.5) {
                        undo.put(currentBlock);
                        if (currentBlock.getType() == Material.COBBLESTONE) continue;
                        currentBlock.setType(Material.COBBLESTONE);
                        continue;
                    }
                    if (fireDensity >= -0.25) {
                        undo.put(currentBlock);
                        if (currentBlock.getType() == Material.FIRE) continue;
                        currentBlock.setType(Material.FIRE);
                        continue;
                    }
                    if (!(airDensity >= 0.0)) continue;
                    undo.put(currentBlock);
                    if (currentBlock.getType() == Material.AIR) continue;
                    currentBlock.setType(Material.AIR);
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.heatRay(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.heatRay(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GREEN + "Octaves: " + this.octaves);
        vm.custom(ChatColor.GREEN + "Amplitude: " + this.amplitude);
        vm.custom(ChatColor.GREEN + "Frequency: " + this.frequency);
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i].toLowerCase();
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Heat Ray brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b hr oct[int] -- Octaves parameter for the noise generator.");
                v.sendMessage(ChatColor.AQUA + "/b hr amp[float] -- Amplitude parameter for the noise generator.");
                v.sendMessage(ChatColor.AQUA + "/b hr freq[float] -- Frequency parameter for the noise generator.");
            }
            if (parameter.startsWith("oct")) {
                this.octaves = Integer.valueOf(parameter.replace("oct", ""));
                v.getVoxelMessage().custom(ChatColor.GREEN + "Octaves: " + this.octaves);
                continue;
            }
            if (parameter.startsWith("amp")) {
                this.amplitude = Double.valueOf(parameter.replace("amp", ""));
                v.getVoxelMessage().custom(ChatColor.GREEN + "Amplitude: " + this.amplitude);
                continue;
            }
            if (!parameter.startsWith("freq")) continue;
            this.frequency = Double.valueOf(parameter.replace("freq", ""));
            v.getVoxelMessage().custom(ChatColor.GREEN + "Frequency: " + this.frequency);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.heatray";
    }

    static {
        for (FlameableBlock flameableBlock : FlameableBlock.values()) {
            FLAMABLE_BLOCKS.add(flameableBlock.material);
        }
    }

    private static enum FlameableBlock {
        WOOD(Material.WOOD),
        SAPLING(Material.SAPLING),
        LOG(Material.LOG),
        LEAVES(Material.LEAVES),
        SPONGE(Material.SPONGE),
        WEB(Material.WEB),
        LONG_GRASS(Material.LONG_GRASS),
        DEAD_BUSH(Material.DEAD_BUSH),
        WOOL(Material.WOOL),
        YELLOW_FLOWER(Material.YELLOW_FLOWER),
        RED_ROSE(Material.RED_ROSE),
        TORCH(Material.TORCH),
        FIRE(Material.FIRE),
        WOOD_STAIRS(Material.WOOD_STAIRS),
        CROPS(Material.CROPS),
        SIGN_POST(Material.SIGN_POST),
        WOODEN_DOOR(Material.WOODEN_DOOR),
        LADDER(Material.LADDER),
        WALL_SIGN(Material.WALL_SIGN),
        WOOD_PLATE(Material.WOOD_PLATE),
        SNOW(Material.SNOW),
        ICE(Material.ICE),
        SUGAR_CANE_BLOCK(Material.SUGAR_CANE_BLOCK),
        FENCE(Material.FENCE),
        TRAP_DOOR(Material.TRAP_DOOR),
        VINE(Material.VINE),
        FENCE_GATE(Material.FENCE_GATE),
        WATER_LILLY(Material.WATER_LILY);

        private Material material;

        private FlameableBlock(Material material) {
            this.material = material;
        }
    }
}

