/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class GenerateTreeBrush
extends Brush {
    private Random randGenerator = new Random();
    private ArrayList<Block> branchBlocks = new ArrayList();
    private Undo undo;
    private byte leafType = 0;
    private byte woodType = 0;
    private boolean rootFloat = false;
    private int startHeight = 0;
    private int rootLength = 9;
    private int maxRoots = 2;
    private int minRoots = 1;
    private int thickness = 1;
    private int slopeChance = 40;
    private int twistChance = 5;
    private int heightMininmum = 14;
    private int heightMaximum = 18;
    private int branchLength = 8;
    private int nodeMax = 4;
    private int nodeMin = 3;
    private int blockPositionX;
    private int blockPositionY;
    private int blockPositionZ;

    public GenerateTreeBrush() {
        this.setName("Generate Tree");
    }

    private void branchCreate(int xDirection, int zDirection) {
        int originX = this.blockPositionX;
        int originY = this.blockPositionY;
        int originZ = this.blockPositionZ;
        int xPreference = this.randGenerator.nextInt(60) + 20;
        int zPreference = this.randGenerator.nextInt(60) + 20;
        for (int r = 0; r < this.branchLength; ++r) {
            if (this.randGenerator.nextInt(100) < xPreference) {
                this.blockPositionX += 1 * xDirection;
            }
            if (this.randGenerator.nextInt(100) < zPreference) {
                this.blockPositionZ += 1 * zDirection;
            }
            if (Math.abs(r % 2) == 1) {
                this.blockPositionY += this.randGenerator.nextInt(2);
            }
            if (this.getBlockIdAt(this.blockPositionX, this.blockPositionY, this.blockPositionZ) != Material.LOG.getId()) {
                this.undo.put(this.clampY(this.blockPositionX, this.blockPositionY, this.blockPositionZ));
            }
            this.clampY(this.blockPositionX, this.blockPositionY, this.blockPositionZ).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
            this.branchBlocks.add(this.clampY(this.blockPositionX, this.blockPositionY, this.blockPositionZ));
        }
        this.blockPositionX = originX;
        this.blockPositionY = originY;
        this.blockPositionZ = originZ;
    }

    private void leafNodeCreate() {
        int nodeRadius = this.randGenerator.nextInt(this.nodeMax - this.nodeMin + 1) + this.nodeMin;
        double bSquared = Math.pow((double)nodeRadius + 0.5, 2.0);
        this.blockPositionY -= 2;
        for (int z = nodeRadius; z >= 0; --z) {
            double zSquared = Math.pow(z, 2.0);
            for (int x = nodeRadius; x >= 0; --x) {
                double xSquared = Math.pow(x, 2.0);
                for (int y = nodeRadius; y >= 0; --y) {
                    if (!(xSquared + Math.pow(y, 2.0) + zSquared <= bSquared)) continue;
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ + z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ + z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ + z));
                        }
                        this.clampY(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ + z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ - z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ - z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ - z));
                        }
                        this.clampY(this.blockPositionX + x, this.blockPositionY + y, this.blockPositionZ - z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ + z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ + z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ + z));
                        }
                        this.clampY(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ + z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ - z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ - z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ - z));
                        }
                        this.clampY(this.blockPositionX - x, this.blockPositionY + y, this.blockPositionZ - z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ + z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ + z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ + z));
                        }
                        this.clampY(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ + z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ - z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ - z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ - z));
                        }
                        this.clampY(this.blockPositionX + x, this.blockPositionY - y, this.blockPositionZ - z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) >= 30 && this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ + z) == Material.AIR.getId()) {
                        if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ + z) != Material.LEAVES.getId()) {
                            this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ + z));
                        }
                        this.clampY(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ + z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                    }
                    if (this.randGenerator.nextInt(100) < 30 || this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ - z) != Material.AIR.getId()) continue;
                    if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ - z) != Material.LEAVES.getId()) {
                        this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ - z));
                    }
                    this.clampY(this.blockPositionX - x, this.blockPositionY - y, this.blockPositionZ - z).setTypeIdAndData(Material.LEAVES.getId(), this.leafType, false);
                }
            }
        }
    }

    private void rootCreate(int xDirection, int zDirection) {
        int originX = this.blockPositionX;
        int originY = this.blockPositionY;
        int originZ = this.blockPositionZ;
        int roots = this.randGenerator.nextInt(this.maxRoots - this.minRoots + 1) + this.minRoots;
        for (int i = 0; i < roots; ++i) {
            for (int t = 0; t < this.thickness - 1; ++t) {
                this.blockPositionX += xDirection;
                this.blockPositionZ += zDirection;
            }
            int xPreference = this.randGenerator.nextInt(30) + 40;
            int zPreference = this.randGenerator.nextInt(30) + 40;
            for (int j = 0; j < this.rootLength && this.getBlockIdAt(this.blockPositionX, this.blockPositionY, this.blockPositionZ) != Material.LOG.getId(); ++j) {
                this.undo.put(this.clampY(this.blockPositionX, this.blockPositionY, this.blockPositionZ));
                this.clampY(this.blockPositionX, this.blockPositionY, this.blockPositionZ).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
                if (this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() == Material.AIR || this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() == Material.WATER || this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() == Material.STATIONARY_WATER || this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() == Material.SNOW || this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() == Material.LOG) {
                    --this.blockPositionY;
                    if (!this.rootFloat) continue;
                    if (this.randGenerator.nextInt(100) < xPreference) {
                        this.blockPositionX += xDirection;
                    }
                    if (this.randGenerator.nextInt(100) >= zPreference) continue;
                    this.blockPositionZ += zDirection;
                    continue;
                }
                if (this.randGenerator.nextInt(100) < xPreference) {
                    this.blockPositionX += xDirection;
                }
                if (this.randGenerator.nextInt(100) < zPreference) {
                    this.blockPositionZ += zDirection;
                }
                if (this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() != Material.AIR && this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() != Material.WATER && this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() != Material.STATIONARY_WATER && this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() != Material.SNOW && this.clampY(this.blockPositionX, this.blockPositionY - 1, this.blockPositionZ).getType() != Material.LOG) continue;
                --this.blockPositionY;
            }
            this.blockPositionX = originX;
            this.blockPositionY = originY;
            this.blockPositionZ = originZ;
        }
    }

    private void rootGen() {
        this.rootCreate(1, 1);
        this.rootCreate(-1, 1);
        this.rootCreate(1, -1);
        this.rootCreate(-1, -1);
    }

    private void trunkCreate() {
        double bSquared = Math.pow((double)this.thickness + 0.5, 2.0);
        for (int x = this.thickness; x >= 0; --x) {
            double xSquared = Math.pow(x, 2.0);
            for (int z = this.thickness; z >= 0; --z) {
                if (!(xSquared + Math.pow(z, 2.0) <= bSquared)) continue;
                if (this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ + z) == Material.AIR.getId()) {
                    if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ + z) != Material.LOG.getId()) {
                        this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ + z));
                    }
                    this.clampY(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ + z).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
                }
                if (this.getWorld().getBlockTypeIdAt(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ - z) == Material.AIR.getId()) {
                    if (this.getBlockIdAt(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ - z) != Material.LOG.getId()) {
                        this.undo.put(this.clampY(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ - z));
                    }
                    this.clampY(this.blockPositionX + x, this.blockPositionY, this.blockPositionZ - z).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
                }
                if (this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ + z) == Material.AIR.getId()) {
                    if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ + z) != Material.LOG.getId()) {
                        this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ + z));
                    }
                    this.clampY(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ + z).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
                }
                if (this.getWorld().getBlockTypeIdAt(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ - z) != Material.AIR.getId()) continue;
                if (this.getBlockIdAt(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ - z) != Material.LOG.getId()) {
                    this.undo.put(this.clampY(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ - z));
                }
                this.clampY(this.blockPositionX - x, this.blockPositionY, this.blockPositionZ - z).setTypeIdAndData(Material.LOG.getId(), this.woodType, false);
            }
        }
    }

    private void trunkGen() {
        int p;
        int originX = this.blockPositionX;
        int originY = this.blockPositionY;
        int originZ = this.blockPositionZ;
        int xPreference = this.randGenerator.nextInt(this.slopeChance);
        int zPreference = this.randGenerator.nextInt(this.slopeChance);
        int xDirection = 1;
        if (this.randGenerator.nextInt(100) < 50) {
            xDirection = -1;
        }
        int zDirection = 1;
        if (this.randGenerator.nextInt(100) < 50) {
            zDirection = -1;
        }
        int height = this.randGenerator.nextInt(this.heightMaximum - this.heightMininmum + 1) + this.heightMininmum;
        for (p = 0; p < height; ++p) {
            if (p > 3) {
                if (this.randGenerator.nextInt(100) <= this.twistChance) {
                    xDirection *= -1;
                }
                if (this.randGenerator.nextInt(100) <= this.twistChance) {
                    zDirection *= -1;
                }
                if (this.randGenerator.nextInt(100) < xPreference) {
                    this.blockPositionX += xDirection;
                }
                if (this.randGenerator.nextInt(100) < zPreference) {
                    this.blockPositionZ += zDirection;
                }
            }
            this.trunkCreate();
            ++this.blockPositionY;
        }
        this.branchCreate(1, 1);
        this.branchCreate(-1, 1);
        this.branchCreate(1, -1);
        this.branchCreate(-1, -1);
        this.blockPositionX = originX;
        this.blockPositionY = originY + 4;
        this.blockPositionZ = originZ;
        xPreference = this.randGenerator.nextInt(this.slopeChance);
        zPreference = this.randGenerator.nextInt(this.slopeChance);
        xDirection = 1;
        if (this.randGenerator.nextInt(100) < 50) {
            xDirection = -1;
        }
        zDirection = 1;
        if (this.randGenerator.nextInt(100) < 50) {
            zDirection = -1;
        }
        if ((height = this.randGenerator.nextInt(this.heightMaximum - this.heightMininmum + 1) + this.heightMininmum) > 4) {
            for (p = 0; p < height; ++p) {
                if (this.randGenerator.nextInt(100) <= this.twistChance) {
                    xDirection *= -1;
                }
                if (this.randGenerator.nextInt(100) <= this.twistChance) {
                    zDirection *= -1;
                }
                if (this.randGenerator.nextInt(100) < xPreference) {
                    this.blockPositionX += 1 * xDirection;
                }
                if (this.randGenerator.nextInt(100) < zPreference) {
                    this.blockPositionZ += 1 * zDirection;
                }
                this.trunkCreate();
                ++this.blockPositionY;
            }
            this.branchCreate(1, 1);
            this.branchCreate(-1, 1);
            this.branchCreate(1, -1);
            this.branchCreate(-1, -1);
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.undo = new Undo();
        this.branchBlocks.clear();
        this.blockPositionX = this.getTargetBlock().getX();
        this.blockPositionY = this.getTargetBlock().getY() + this.startHeight;
        this.blockPositionZ = this.getTargetBlock().getZ();
        this.rootGen();
        this.trunkGen();
        for (Block block : this.branchBlocks) {
            this.blockPositionX = block.getX();
            this.blockPositionY = block.getY();
            this.blockPositionZ = block.getZ();
            this.leafNodeCreate();
        }
        v.owner().storeUndo(this.undo);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.arrow(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            try {
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.GOLD + "This brush takes the following parameters:");
                    v.sendMessage(ChatColor.AQUA + "lt# - leaf type (data value)");
                    v.sendMessage(ChatColor.AQUA + "wt# - wood type (data value)");
                    v.sendMessage(ChatColor.AQUA + "tt# - tree thickness (whote number)");
                    v.sendMessage(ChatColor.AQUA + "rfX - root float (true or false)");
                    v.sendMessage(ChatColor.AQUA + "sh# - starting height (whole number)");
                    v.sendMessage(ChatColor.AQUA + "rl# - root length (whole number)");
                    v.sendMessage(ChatColor.AQUA + "ts# - trunk slope chance (0-100)");
                    v.sendMessage(ChatColor.AQUA + "bl# - branch length (whole number)");
                    v.sendMessage(ChatColor.AQUA + "info2 - more parameters");
                    return;
                }
                if (parameter.equalsIgnoreCase("info2")) {
                    v.sendMessage(ChatColor.GOLD + "This brush takes the following parameters:");
                    v.sendMessage(ChatColor.AQUA + "minr# - minimum roots (whole number)");
                    v.sendMessage(ChatColor.AQUA + "maxr# - maximum roots (whole number)");
                    v.sendMessage(ChatColor.AQUA + "minh# - minimum height (whole number)");
                    v.sendMessage(ChatColor.AQUA + "maxh# - maximum height (whole number)");
                    v.sendMessage(ChatColor.AQUA + "minl# - minimum leaf node size (whole number)");
                    v.sendMessage(ChatColor.AQUA + "maxl# - maximum leaf node size (whole number)");
                    v.sendMessage(ChatColor.AQUA + "default - restore default params");
                    return;
                }
                if (parameter.startsWith("lt")) {
                    this.leafType = Byte.parseByte(parameter.replace("lt", ""));
                    v.sendMessage(ChatColor.BLUE + "Leaf Type set to " + this.leafType);
                    continue;
                }
                if (parameter.startsWith("wt")) {
                    this.woodType = Byte.parseByte(parameter.replace("wt", ""));
                    v.sendMessage(ChatColor.BLUE + "Wood Type set to " + this.woodType);
                    continue;
                }
                if (parameter.startsWith("tt")) {
                    this.thickness = Integer.parseInt(parameter.replace("tt", ""));
                    v.sendMessage(ChatColor.BLUE + "Thickness set to " + this.thickness);
                    continue;
                }
                if (parameter.startsWith("rf")) {
                    this.rootFloat = Boolean.parseBoolean(parameter.replace("rf", ""));
                    v.sendMessage(ChatColor.BLUE + "Floating Roots set to " + this.rootFloat);
                    continue;
                }
                if (parameter.startsWith("sh")) {
                    this.startHeight = Integer.parseInt(parameter.replace("sh", ""));
                    v.sendMessage(ChatColor.BLUE + "Starting Height set to " + this.startHeight);
                    continue;
                }
                if (parameter.startsWith("rl")) {
                    this.rootLength = Integer.parseInt(parameter.replace("rl", ""));
                    v.sendMessage(ChatColor.BLUE + "Root Length set to " + this.rootLength);
                    continue;
                }
                if (parameter.startsWith("minr")) {
                    this.minRoots = Integer.parseInt(parameter.replace("minr", ""));
                    if (this.minRoots > this.maxRoots) {
                        this.minRoots = this.maxRoots;
                        v.sendMessage(ChatColor.RED + "Minimum Roots can't exceed Maximum Roots, has  been set to " + this.minRoots + " Instead!");
                        continue;
                    }
                    v.sendMessage(ChatColor.BLUE + "Minimum Roots set to " + this.minRoots);
                    continue;
                }
                if (parameter.startsWith("maxr")) {
                    this.maxRoots = Integer.parseInt(parameter.replace("maxr", ""));
                    if (this.minRoots > this.maxRoots) {
                        this.maxRoots = this.minRoots;
                        v.sendMessage(ChatColor.RED + "Maximum Roots can't be lower than Minimum Roots, has been set to " + this.minRoots + " Instead!");
                        continue;
                    }
                    v.sendMessage(ChatColor.BLUE + "Maximum Roots set to " + this.maxRoots);
                    continue;
                }
                if (parameter.startsWith("ts")) {
                    this.slopeChance = Integer.parseInt(parameter.replace("ts", ""));
                    v.sendMessage(ChatColor.BLUE + "Trunk Slope set to " + this.slopeChance);
                    continue;
                }
                if (parameter.startsWith("minh")) {
                    this.heightMininmum = Integer.parseInt(parameter.replace("minh", ""));
                    if (this.heightMininmum > this.heightMaximum) {
                        this.heightMininmum = this.heightMaximum;
                        v.sendMessage(ChatColor.RED + "Minimum Height exceed than Maximum Height, has been set to " + this.heightMininmum + " Instead!");
                        continue;
                    }
                    v.sendMessage(ChatColor.BLUE + "Minimum Height set to " + this.heightMininmum);
                    continue;
                }
                if (parameter.startsWith("maxh")) {
                    this.heightMaximum = Integer.parseInt(parameter.replace("maxh", ""));
                    if (this.heightMininmum > this.heightMaximum) {
                        this.heightMaximum = this.heightMininmum;
                        v.sendMessage(ChatColor.RED + "Maximum Height can't be lower than Minimum Height, has been set to " + this.heightMaximum + " Instead!");
                        continue;
                    }
                    v.sendMessage(ChatColor.BLUE + "Maximum Roots set to " + this.heightMaximum);
                    continue;
                }
                if (parameter.startsWith("bl")) {
                    this.branchLength = Integer.parseInt(parameter.replace("bl", ""));
                    v.sendMessage(ChatColor.BLUE + "Branch Length set to " + this.branchLength);
                    continue;
                }
                if (parameter.startsWith("maxl")) {
                    this.nodeMax = Integer.parseInt(parameter.replace("maxl", ""));
                    v.sendMessage(ChatColor.BLUE + "Leaf Max Thickness set to " + this.nodeMax + " (Default 4)");
                    continue;
                }
                if (parameter.startsWith("minl")) {
                    this.nodeMin = Integer.parseInt(parameter.replace("minl", ""));
                    v.sendMessage(ChatColor.BLUE + "Leaf Min Thickness set to " + this.nodeMin + " (Default 3)");
                    continue;
                }
                if (parameter.startsWith("default")) {
                    this.leafType = 0;
                    this.woodType = 0;
                    this.rootFloat = false;
                    this.startHeight = 0;
                    this.rootLength = 9;
                    this.maxRoots = 2;
                    this.minRoots = 1;
                    this.thickness = 1;
                    this.slopeChance = 40;
                    this.heightMininmum = 14;
                    this.heightMaximum = 18;
                    this.branchLength = 8;
                    this.nodeMax = 4;
                    this.nodeMin = 3;
                    v.sendMessage(ChatColor.GOLD + "Brush reset to default parameters.");
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
                continue;
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! \"" + par[i] + "\" is not a valid statement. Please use the 'info' parameter to display parameter info.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.generatetree";
    }
}

