/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;

public class FlatOceanBrush
extends Brush {
    private static final int DEFAULT_WATER_LEVEL = 29;
    private static final int DEFAULT_FLOOR_LEVEL = 8;
    private int waterLevel = 29;
    private int floorLevel = 8;

    public FlatOceanBrush() {
        this.setName("FlatOcean");
    }

    private void flatOcean(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < chunk.getWorld().getMaxHeight(); ++y) {
                    if (y <= this.floorLevel) {
                        chunk.getBlock(x, y, z).setType(Material.DIRT);
                        continue;
                    }
                    if (y <= this.waterLevel) {
                        chunk.getBlock(x, y, z).setTypeId(Material.STATIONARY_WATER.getId(), false);
                        continue;
                    }
                    chunk.getBlock(x, y, z).setTypeId(Material.AIR.getId(), false);
                }
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.flatOcean(this.getWorld().getChunkAt(this.getTargetBlock()));
    }

    @Override
    protected final void powder(SnipeData v) {
        this.flatOcean(this.getWorld().getChunkAt(this.getTargetBlock()));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() + 16, 1, this.getTargetBlock().getZ())));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() + 16, 1, this.getTargetBlock().getZ() + 16)));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX(), 1, this.getTargetBlock().getZ() + 16)));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() - 16, 1, this.getTargetBlock().getZ() + 16)));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() - 16, 1, this.getTargetBlock().getZ())));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() - 16, 1, this.getTargetBlock().getZ() - 16)));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX(), 1, this.getTargetBlock().getZ() - 16)));
        this.flatOcean(this.getWorld().getChunkAt(this.clampY(this.getTargetBlock().getX() + 16, 1, this.getTargetBlock().getZ() - 16)));
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.RED + "THIS BRUSH DOES NOT UNDO");
        vm.custom(ChatColor.GREEN + "Water level set to " + this.waterLevel);
        vm.custom(ChatColor.GREEN + "Ocean floor level set to " + this.floorLevel);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GREEN + "yo[number] to set the Level to which the water will rise.");
                v.sendMessage(ChatColor.GREEN + "yl[number] to set the Level to which the ocean floor will rise.");
            }
            if (parameter.startsWith("yo")) {
                int newWaterLevel = Integer.parseInt(parameter.replace("yo", ""));
                if (newWaterLevel < this.floorLevel) {
                    newWaterLevel = this.floorLevel + 1;
                }
                this.waterLevel = newWaterLevel;
                v.sendMessage(ChatColor.GREEN + "Water Level set to " + this.waterLevel);
                continue;
            }
            if (!parameter.startsWith("yl")) continue;
            int newFloorLevel = Integer.parseInt(parameter.replace("yl", ""));
            if (newFloorLevel > this.waterLevel && (newFloorLevel = this.waterLevel - 1) == 0) {
                newFloorLevel = 1;
                this.waterLevel = 2;
            }
            this.floorLevel = newFloorLevel;
            v.sendMessage(ChatColor.GREEN + "Ocean floor Level set to " + this.floorLevel);
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.flatocean";
    }
}

