/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.HashSet;
import org.bukkit.block.Block;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class DomeBrush
extends Brush {
    public DomeBrush() {
        this.setName("Dome");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.height();
    }

    private void generateDome(SnipeData v, Block targetBlock) {
        if (v.getVoxelHeight() == 0) {
            v.sendMessage("VoxelHeight must not be 0.");
            return;
        }
        int absoluteHeight = Math.abs(v.getVoxelHeight());
        boolean negative = v.getVoxelHeight() < 0;
        HashSet<Vector> changeablePositions = new HashSet<Vector>();
        Undo undo = new Undo();
        int brushSizeTimesVoxelHeight = v.getBrushSize() * absoluteHeight;
        double stepScale = (v.getBrushSize() * v.getBrushSize() + brushSizeTimesVoxelHeight + brushSizeTimesVoxelHeight) / 5;
        double stepSize = 1.0 / stepScale;
        for (double u = 0.0; u <= 1.5707963267948966; u += stepSize) {
            double y = (double)absoluteHeight * Math.sin(u);
            for (double stepV = -Math.PI; stepV <= -1.5707963267948966; stepV += stepSize) {
                double x = (double)v.getBrushSize() * Math.cos(u) * Math.cos(stepV);
                double z = (double)v.getBrushSize() * Math.cos(u) * Math.sin(stepV);
                double targetBlockX = (double)targetBlock.getX() + 0.5;
                double targetBlockZ = (double)targetBlock.getZ() + 0.5;
                int targetY = NumberConversions.floor((double)((double)targetBlock.getY() + (negative ? -y : y)));
                int currentBlockXAdd = NumberConversions.floor((double)(targetBlockX + x));
                int currentBlockZAdd = NumberConversions.floor((double)(targetBlockZ + z));
                int currentBlockXSubtract = NumberConversions.floor((double)(targetBlockX - x));
                int currentBlockZSubtract = NumberConversions.floor((double)(targetBlockZ - z));
                changeablePositions.add(new Vector(currentBlockXAdd, targetY, currentBlockZAdd));
                changeablePositions.add(new Vector(currentBlockXSubtract, targetY, currentBlockZAdd));
                changeablePositions.add(new Vector(currentBlockXAdd, targetY, currentBlockZSubtract));
                changeablePositions.add(new Vector(currentBlockXSubtract, targetY, currentBlockZSubtract));
            }
        }
        for (Vector vector : changeablePositions) {
            Block currentTargetBlock = vector.toLocation(this.getTargetBlock().getWorld()).getBlock();
            if (currentTargetBlock.getTypeId() == v.getVoxelId() && currentTargetBlock.getData() == v.getData()) continue;
            undo.put(currentTargetBlock);
            currentTargetBlock.setTypeIdAndData(v.getVoxelId(), v.getData(), true);
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.generateDome(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.generateDome(v, this.getLastBlock());
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.dome";
    }
}

