/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class BlockResetBrush
extends Brush {
    private static final ArrayList<Material> DENIED_UPDATES = new ArrayList();

    public BlockResetBrush() {
        this.setName("Block Reset Brush");
    }

    private void applyBrush(SnipeData v) {
        for (int z = -v.getBrushSize(); z <= v.getBrushSize(); ++z) {
            for (int x = -v.getBrushSize(); x <= v.getBrushSize(); ++x) {
                for (int y = -v.getBrushSize(); y <= v.getBrushSize(); ++y) {
                    Block block = this.getWorld().getBlockAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY() + y, this.getTargetBlock().getZ() + z);
                    if (DENIED_UPDATES.contains(block.getType())) continue;
                    byte oldData = block.getData();
                    block.setTypeIdAndData(block.getTypeId(), (byte)(block.getData() + 1 & 0xF), true);
                    block.setTypeIdAndData(block.getTypeId(), oldData, true);
                }
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.applyBrush(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.applyBrush(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blockreset";
    }

    static {
        DENIED_UPDATES.add(Material.SIGN);
        DENIED_UPDATES.add(Material.SIGN_POST);
        DENIED_UPDATES.add(Material.WALL_SIGN);
        DENIED_UPDATES.add(Material.CHEST);
        DENIED_UPDATES.add(Material.FURNACE);
        DENIED_UPDATES.add(Material.BURNING_FURNACE);
        DENIED_UPDATES.add(Material.REDSTONE_TORCH_OFF);
        DENIED_UPDATES.add(Material.REDSTONE_TORCH_ON);
        DENIED_UPDATES.add(Material.REDSTONE_WIRE);
        DENIED_UPDATES.add(Material.DIODE_BLOCK_OFF);
        DENIED_UPDATES.add(Material.DIODE_BLOCK_ON);
        DENIED_UPDATES.add(Material.WOODEN_DOOR);
        DENIED_UPDATES.add(Material.WOOD_DOOR);
        DENIED_UPDATES.add(Material.IRON_DOOR);
        DENIED_UPDATES.add(Material.IRON_DOOR_BLOCK);
        DENIED_UPDATES.add(Material.FENCE_GATE);
    }
}

