/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.BlendBrushBase;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class BlendVoxelDiscBrush
extends BlendBrushBase {
    public BlendVoxelDiscBrush() {
        this.setName("Blend Voxel Disc");
    }

    @Override
    protected final void blend(SnipeData v) {
        int z;
        int x;
        int brushSize = v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][] oldMaterials = new int[2 * (brushSize + 1) + 1][2 * (brushSize + 1) + 1];
        int[][] newMaterials = new int[brushSizeDoubled + 1][brushSizeDoubled + 1];
        for (x = 0; x <= 2 * (brushSize + 1); ++x) {
            for (z = 0; z <= 2 * (brushSize + 1); ++z) {
                oldMaterials[x][z] = this.getBlockIdAt(this.getTargetBlock().getX() - brushSize - 1 + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - brushSize - 1 + z);
            }
        }
        for (x = 0; x <= brushSizeDoubled; ++x) {
            for (z = 0; z <= brushSizeDoubled; ++z) {
                newMaterials[x][z] = oldMaterials[x + 1][z + 1];
            }
        }
        for (x = 0; x <= brushSizeDoubled; ++x) {
            for (z = 0; z <= brushSizeDoubled; ++z) {
                int i;
                int[] materialFrequency = new int[BlendBrushBase.getMaxBlockMaterialID() + 1];
                int modeMatCount = 0;
                int modeMatId = 0;
                boolean tiecheck = true;
                for (int m = -1; m <= 1; ++m) {
                    for (int n = -1; n <= 1; ++n) {
                        if (m == 0 && n == 0) continue;
                        int n2 = oldMaterials[x + 1 + m][z + 1 + n];
                        materialFrequency[n2] = materialFrequency[n2] + 1;
                    }
                }
                for (i = 0; i <= BlendBrushBase.getMaxBlockMaterialID(); ++i) {
                    if (materialFrequency[i] <= modeMatCount || this.excludeAir && i == Material.AIR.getId() || this.excludeWater && (i == Material.WATER.getId() || i == Material.STATIONARY_WATER.getId())) continue;
                    modeMatCount = materialFrequency[i];
                    modeMatId = i;
                }
                for (i = 0; i < modeMatId; ++i) {
                    if (materialFrequency[i] != modeMatCount || this.excludeAir && i == Material.AIR.getId() || this.excludeWater && (i == Material.WATER.getId() || i == Material.STATIONARY_WATER.getId())) continue;
                    tiecheck = false;
                }
                if (!tiecheck) continue;
                newMaterials[x][z] = modeMatId;
            }
        }
        Undo undo = new Undo();
        for (int x2 = brushSizeDoubled; x2 >= 0; --x2) {
            for (int z2 = brushSizeDoubled; z2 >= 0; --z2) {
                if (this.excludeAir && newMaterials[x2][z2] == Material.AIR.getId() || this.excludeWater && (newMaterials[x2][z2] == Material.WATER.getId() || newMaterials[x2][z2] == Material.STATIONARY_WATER.getId())) continue;
                if (this.getBlockIdAt(this.getTargetBlock().getX() - brushSize + x2, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - brushSize + z2) != newMaterials[x2][z2]) {
                    undo.put(this.clampY(this.getTargetBlock().getX() - brushSize + x2, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - brushSize + z2));
                }
                this.setBlockIdAt(this.getTargetBlock().getZ() - brushSize + z2, this.getTargetBlock().getX() - brushSize + x2, this.getTargetBlock().getY(), newMaterials[x2][z2]);
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Blend Voxel Disc Parameters:");
            v.sendMessage(ChatColor.AQUA + "/b bvd water -- toggle include or exclude (default) water");
            return;
        }
        super.parameters(par, v);
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blendvoxeldisc";
    }
}

