/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.Sniper;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.api.command.VoxelCommand;
import com.thevoxelbox.voxelsniper.command.VoxelBrushCommand;
import com.thevoxelbox.voxelsniper.command.VoxelBrushToolCommand;
import com.thevoxelbox.voxelsniper.command.VoxelCenterCommand;
import com.thevoxelbox.voxelsniper.command.VoxelChunkCommand;
import com.thevoxelbox.voxelsniper.command.VoxelDefaultCommand;
import com.thevoxelbox.voxelsniper.command.VoxelGoToCommand;
import com.thevoxelbox.voxelsniper.command.VoxelHeightCommand;
import com.thevoxelbox.voxelsniper.command.VoxelInkCommand;
import com.thevoxelbox.voxelsniper.command.VoxelInkReplaceCommand;
import com.thevoxelbox.voxelsniper.command.VoxelListCommand;
import com.thevoxelbox.voxelsniper.command.VoxelPaintCommand;
import com.thevoxelbox.voxelsniper.command.VoxelPerformerCommand;
import com.thevoxelbox.voxelsniper.command.VoxelReplaceCommand;
import com.thevoxelbox.voxelsniper.command.VoxelSniperCommand;
import com.thevoxelbox.voxelsniper.command.VoxelUndoCommand;
import com.thevoxelbox.voxelsniper.command.VoxelUndoUserCommand;
import com.thevoxelbox.voxelsniper.command.VoxelVoxelCommand;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class VoxelSniperListener
implements Listener {
    private static final String SNIPER_PERMISSION = "voxelsniper.sniper";
    private final VoxelSniper plugin;
    private Map<String, VoxelCommand> commands = new HashMap<String, VoxelCommand>();

    public VoxelSniperListener(VoxelSniper plugin) {
        this.plugin = plugin;
        this.addCommand(new VoxelBrushCommand(plugin));
        this.addCommand(new VoxelBrushToolCommand(plugin));
        this.addCommand(new VoxelCenterCommand(plugin));
        this.addCommand(new VoxelChunkCommand(plugin));
        this.addCommand(new VoxelDefaultCommand(plugin));
        this.addCommand(new VoxelGoToCommand(plugin));
        this.addCommand(new VoxelHeightCommand(plugin));
        this.addCommand(new VoxelInkCommand(plugin));
        this.addCommand(new VoxelInkReplaceCommand(plugin));
        this.addCommand(new VoxelListCommand(plugin));
        this.addCommand(new VoxelPaintCommand(plugin));
        this.addCommand(new VoxelPerformerCommand(plugin));
        this.addCommand(new VoxelReplaceCommand(plugin));
        this.addCommand(new VoxelSniperCommand(plugin));
        this.addCommand(new VoxelUndoCommand(plugin));
        this.addCommand(new VoxelUndoUserCommand(plugin));
        this.addCommand(new VoxelVoxelCommand(plugin));
    }

    private void addCommand(VoxelCommand command) {
        this.commands.put(command.getIdentifier().toLowerCase(), command);
    }

    public boolean onCommand(Player player, String[] split, String command) {
        VoxelCommand found = this.commands.get(command.toLowerCase());
        if (found == null) {
            return false;
        }
        if (!this.hasPermission(found, player)) {
            player.sendMessage(ChatColor.RED + "Insufficient Permissions.");
            return true;
        }
        return found.onCommand(player, split);
    }

    private boolean hasPermission(VoxelCommand command, Player player) {
        if (command == null || player == null) {
            return false;
        }
        if (command.getPermission() == null || command.getPermission().isEmpty()) {
            return true;
        }
        return player.hasPermission(command.getPermission());
    }

    @EventHandler(ignoreCancelled=false)
    public final void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(SNIPER_PERMISSION)) {
            return;
        }
        try {
            Sniper sniper = this.plugin.getSniperManager().getSniperForPlayer(player);
            if (sniper.isEnabled() && sniper.snipe(event.getAction(), event.getMaterial(), event.getClickedBlock(), event.getBlockFace())) {
                event.setCancelled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public final void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Sniper sniper = this.plugin.getSniperManager().getSniperForPlayer(player);
        if (player.hasPermission(SNIPER_PERMISSION) && this.plugin.getVoxelSniperConfiguration().isMessageOnLoginEnabled()) {
            sniper.displayInfo();
        }
    }
}

