/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.RangeBlockHelper;
import com.thevoxelbox.voxelsniper.SnipeAction;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.brush.SnipeBrush;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import com.thevoxelbox.voxelsniper.brush.perform.Performer;
import com.thevoxelbox.voxelsniper.event.SniperMaterialChangedEvent;
import com.thevoxelbox.voxelsniper.event.SniperReplaceMaterialChangedEvent;
import com.thevoxelbox.voxelsniper.libs.com.google.common.base.Preconditions;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.BiMap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.ClassToInstanceMap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.HashBiMap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.ImmutableBiMap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.Maps;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.MutableClassToInstanceMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.material.MaterialData;

public class Sniper {
    private VoxelSniper plugin;
    private final UUID player;
    private boolean enabled = true;
    private LinkedList<Undo> undoList = new LinkedList();
    private Map<String, SniperTool> tools = Maps.newHashMap();

    public Sniper(VoxelSniper plugin, Player player) {
        this.plugin = plugin;
        this.player = player.getUniqueId();
        SniperTool sniperTool = new SniperTool(this);
        sniperTool.assignAction(SnipeAction.ARROW, Material.ARROW);
        sniperTool.assignAction(SnipeAction.GUNPOWDER, Material.SULPHUR);
        this.tools.put(null, sniperTool);
    }

    public String getCurrentToolId() {
        return this.getToolId(this.getPlayer().getItemInHand() != null ? this.getPlayer().getItemInHand().getType() : null);
    }

    public String getToolId(Material itemInHand) {
        if (itemInHand == null) {
            return null;
        }
        for (Map.Entry<String, SniperTool> entry : this.tools.entrySet()) {
            if (!entry.getValue().hasToolAssigned(itemInHand)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.player);
    }

    public boolean snipe(Action action, Material itemInHand, Block clickedBlock, BlockFace clickedFace) {
        String toolId = this.getToolId(itemInHand);
        SniperTool sniperTool = this.tools.get(toolId);
        switch (action) {
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                break;
            }
            default: {
                return false;
            }
        }
        if (sniperTool.hasToolAssigned(itemInHand)) {
            if (sniperTool.getCurrentBrush() == null) {
                this.getPlayer().sendMessage("No Brush selected.");
                return true;
            }
            if (!this.getPlayer().hasPermission(sniperTool.getCurrentBrush().getPermissionNode())) {
                this.getPlayer().sendMessage("You are not allowed to use this brush. You're missing the permission node '" + sniperTool.getCurrentBrush().getPermissionNode() + "'");
                return true;
            }
            SnipeData snipeData = sniperTool.getSnipeData();
            if (this.getPlayer().isSneaking()) {
                SnipeAction snipeAction = sniperTool.getActionAssigned(itemInHand);
                switch (action) {
                    case LEFT_CLICK_AIR: 
                    case LEFT_CLICK_BLOCK: {
                        Block targetBlock;
                        if (clickedBlock != null) {
                            targetBlock = clickedBlock;
                        } else {
                            RangeBlockHelper rangeBlockHelper = snipeData.isRanged() ? new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld(), (double)snipeData.getRange()) : new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld());
                            targetBlock = snipeData.isRanged() ? rangeBlockHelper.getRangeBlock() : rangeBlockHelper.getTargetBlock();
                        }
                        switch (snipeAction) {
                            case ARROW: {
                                if (targetBlock != null) {
                                    int originalVoxel = snipeData.getVoxelId();
                                    snipeData.setVoxelId(targetBlock.getTypeId());
                                    SniperMaterialChangedEvent event = new SniperMaterialChangedEvent(this, toolId, new MaterialData(originalVoxel, snipeData.getData()), new MaterialData(snipeData.getVoxelId(), snipeData.getData()));
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    snipeData.getVoxelMessage().voxel();
                                    return true;
                                }
                                int originalVoxel = snipeData.getVoxelId();
                                snipeData.setVoxelId(0);
                                SniperMaterialChangedEvent event = new SniperMaterialChangedEvent(this, toolId, new MaterialData(originalVoxel, snipeData.getData()), new MaterialData(snipeData.getVoxelId(), snipeData.getData()));
                                Bukkit.getPluginManager().callEvent((Event)event);
                                snipeData.getVoxelMessage().voxel();
                                return true;
                            }
                            case GUNPOWDER: {
                                if (targetBlock != null) {
                                    byte originalData = snipeData.getData();
                                    snipeData.setData(targetBlock.getData());
                                    SniperMaterialChangedEvent event = new SniperMaterialChangedEvent(this, toolId, new MaterialData(snipeData.getVoxelId(), originalData), new MaterialData(snipeData.getVoxelId(), snipeData.getData()));
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    snipeData.getVoxelMessage().data();
                                    return true;
                                }
                                byte originalData = snipeData.getData();
                                snipeData.setData((byte)0);
                                SniperMaterialChangedEvent event = new SniperMaterialChangedEvent(this, toolId, new MaterialData(snipeData.getVoxelId(), originalData), new MaterialData(snipeData.getVoxelId(), snipeData.getData()));
                                Bukkit.getPluginManager().callEvent((Event)event);
                                snipeData.getVoxelMessage().data();
                                return true;
                            }
                        }
                        break;
                    }
                    case RIGHT_CLICK_AIR: 
                    case RIGHT_CLICK_BLOCK: {
                        Block targetBlock;
                        if (clickedBlock != null) {
                            targetBlock = clickedBlock;
                        } else {
                            RangeBlockHelper rangeBlockHelper = snipeData.isRanged() ? new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld(), (double)snipeData.getRange()) : new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld());
                            targetBlock = snipeData.isRanged() ? rangeBlockHelper.getRangeBlock() : rangeBlockHelper.getTargetBlock();
                        }
                        switch (snipeAction) {
                            case ARROW: {
                                if (targetBlock != null) {
                                    int originalId = snipeData.getReplaceId();
                                    snipeData.setReplaceId(targetBlock.getTypeId());
                                    SniperReplaceMaterialChangedEvent event = new SniperReplaceMaterialChangedEvent(this, toolId, new MaterialData(originalId, snipeData.getReplaceData()), new MaterialData(snipeData.getReplaceId(), snipeData.getReplaceData()));
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    snipeData.getVoxelMessage().replace();
                                    return true;
                                }
                                int originalId = snipeData.getReplaceId();
                                snipeData.setReplaceId(0);
                                SniperReplaceMaterialChangedEvent event = new SniperReplaceMaterialChangedEvent(this, toolId, new MaterialData(originalId, snipeData.getReplaceData()), new MaterialData(snipeData.getReplaceId(), snipeData.getReplaceData()));
                                Bukkit.getPluginManager().callEvent((Event)event);
                                snipeData.getVoxelMessage().replace();
                                return true;
                            }
                            case GUNPOWDER: {
                                if (targetBlock != null) {
                                    byte originalData = snipeData.getReplaceData();
                                    snipeData.setReplaceData(targetBlock.getData());
                                    SniperReplaceMaterialChangedEvent event = new SniperReplaceMaterialChangedEvent(this, toolId, new MaterialData(snipeData.getReplaceId(), originalData), new MaterialData(snipeData.getReplaceId(), snipeData.getReplaceData()));
                                    Bukkit.getPluginManager().callEvent((Event)event);
                                    snipeData.getVoxelMessage().replaceData();
                                    return true;
                                }
                                byte originalData = snipeData.getReplaceData();
                                snipeData.setReplaceData((byte)0);
                                SniperReplaceMaterialChangedEvent event = new SniperReplaceMaterialChangedEvent(this, toolId, new MaterialData(snipeData.getReplaceId(), originalData), new MaterialData(snipeData.getReplaceId(), snipeData.getReplaceData()));
                                Bukkit.getPluginManager().callEvent((Event)event);
                                snipeData.getVoxelMessage().replaceData();
                                return true;
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                Block lastBlock;
                Block targetBlock;
                SnipeAction snipeAction = sniperTool.getActionAssigned(itemInHand);
                switch (action) {
                    case RIGHT_CLICK_AIR: 
                    case RIGHT_CLICK_BLOCK: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (clickedBlock != null) {
                    targetBlock = clickedBlock;
                    lastBlock = clickedBlock.getRelative(clickedFace);
                    if (lastBlock == null) {
                        this.getPlayer().sendMessage(ChatColor.RED + "Snipe target block must be visible.");
                        return true;
                    }
                } else {
                    RangeBlockHelper rangeBlockHelper = snipeData.isRanged() ? new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld(), (double)snipeData.getRange()) : new RangeBlockHelper(this.getPlayer(), this.getPlayer().getWorld());
                    targetBlock = snipeData.isRanged() ? rangeBlockHelper.getRangeBlock() : rangeBlockHelper.getTargetBlock();
                    lastBlock = rangeBlockHelper.getLastBlock();
                    if (targetBlock == null || lastBlock == null) {
                        this.getPlayer().sendMessage(ChatColor.RED + "Snipe target block must be visible.");
                        return true;
                    }
                }
                if (sniperTool.getCurrentBrush() instanceof PerformBrush) {
                    PerformBrush performerBrush = (PerformBrush)sniperTool.getCurrentBrush();
                    performerBrush.initP(snipeData);
                }
                boolean result = sniperTool.getCurrentBrush().perform(snipeAction, snipeData, targetBlock, lastBlock);
                return result;
            }
        }
        return false;
    }

    public IBrush setBrush(String toolId, Class<? extends IBrush> brush) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).setCurrentBrush(brush);
    }

    public IBrush getBrush(String toolId) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).getCurrentBrush();
    }

    public IBrush previousBrush(String toolId) {
        if (!this.tools.containsKey(toolId)) {
            return null;
        }
        return this.tools.get(toolId).previousBrush();
    }

    public boolean setTool(String toolId, SnipeAction action, Material itemInHand) {
        for (Map.Entry<String, SniperTool> entry : this.tools.entrySet()) {
            if (entry.getKey() == toolId || !entry.getValue().hasToolAssigned(itemInHand)) continue;
            return false;
        }
        if (!this.tools.containsKey(toolId)) {
            SniperTool tool = new SniperTool(this);
            this.tools.put(toolId, tool);
        }
        this.tools.get(toolId).assignAction(action, itemInHand);
        return true;
    }

    public void removeTool(String toolId, Material itemInHand) {
        if (!this.tools.containsKey(toolId)) {
            SniperTool tool = new SniperTool(this);
            this.tools.put(toolId, tool);
        }
        this.tools.get(toolId).unassignAction(itemInHand);
    }

    public void removeTool(String toolId) {
        if (toolId == null) {
            return;
        }
        this.tools.remove(toolId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void storeUndo(Undo undo) {
        if (VoxelSniper.getInstance().getVoxelSniperConfiguration().getUndoCacheSize() <= 0) {
            return;
        }
        if (undo != null && undo.getSize() > 0) {
            while (this.undoList.size() >= this.plugin.getVoxelSniperConfiguration().getUndoCacheSize()) {
                this.undoList.pollLast();
            }
            this.undoList.push(undo);
        }
    }

    public void undo() {
        this.undo(1);
    }

    public void undo(int amount) {
        int sum = 0;
        if (this.undoList.isEmpty()) {
            this.getPlayer().sendMessage(ChatColor.GREEN + "There's nothing to undo.");
        } else {
            Undo undo;
            for (int x = 0; x < amount && !this.undoList.isEmpty() && (undo = this.undoList.pop()) != null; ++x) {
                undo.undo();
                sum += undo.getSize();
            }
            this.getPlayer().sendMessage(ChatColor.GREEN + "Undo successful:  " + ChatColor.RED + sum + ChatColor.GREEN + " blocks have been replaced.");
        }
    }

    public void reset(String toolId) {
        SniperTool backup = this.tools.remove(toolId);
        SniperTool newTool = new SniperTool(this);
        for (Map.Entry entry : backup.getActionTools().entrySet()) {
            newTool.assignAction((SnipeAction)((Object)entry.getKey()), (Material)entry.getValue());
        }
        this.tools.put(toolId, newTool);
    }

    public SnipeData getSnipeData(String toolId) {
        return this.tools.containsKey(toolId) ? this.tools.get(toolId).getSnipeData() : null;
    }

    public void displayInfo() {
        String currentToolId = this.getCurrentToolId();
        SniperTool sniperTool = this.tools.get(currentToolId);
        IBrush brush = sniperTool.getCurrentBrush();
        this.getPlayer().sendMessage("Current Tool: " + (currentToolId != null ? currentToolId : "Default Tool"));
        if (brush == null) {
            this.getPlayer().sendMessage("No brush selected.");
            return;
        }
        brush.info(sniperTool.getMessageHelper());
        if (brush instanceof Performer) {
            ((Performer)((Object)brush)).showInfo(sniperTool.getMessageHelper());
        }
    }

    public SniperTool getSniperTool(String toolId) {
        return this.tools.get(toolId);
    }

    public class SniperTool {
        private BiMap<SnipeAction, Material> actionTools = HashBiMap.create();
        private ClassToInstanceMap<IBrush> brushes = MutableClassToInstanceMap.create();
        private Class<? extends IBrush> currentBrush;
        private Class<? extends IBrush> previousBrush;
        private SnipeData snipeData;
        private Message messageHelper;

        private SniperTool(Sniper owner) {
            this(SnipeBrush.class, new SnipeData(owner));
        }

        private SniperTool(Class<? extends IBrush> currentBrush, SnipeData snipeData) {
            this.snipeData = snipeData;
            this.messageHelper = new Message(snipeData);
            snipeData.setVoxelMessage(this.messageHelper);
            IBrush newBrushInstance = this.instanciateBrush(currentBrush);
            if (snipeData.owner().getPlayer().hasPermission(newBrushInstance.getPermissionNode())) {
                this.brushes.put(currentBrush, newBrushInstance);
                this.currentBrush = currentBrush;
            }
        }

        public boolean hasToolAssigned(Material material) {
            return this.actionTools.containsValue(material);
        }

        public SnipeAction getActionAssigned(Material itemInHand) {
            return (SnipeAction)((Object)this.actionTools.inverse().get(itemInHand));
        }

        public Material getToolAssigned(SnipeAction action) {
            return (Material)this.actionTools.get((Object)action);
        }

        public void assignAction(SnipeAction action, Material itemInHand) {
            this.actionTools.forcePut(action, itemInHand);
        }

        public void unassignAction(Material itemInHand) {
            this.actionTools.inverse().remove(itemInHand);
        }

        public BiMap<SnipeAction, Material> getActionTools() {
            return ImmutableBiMap.copyOf(this.actionTools);
        }

        public SnipeData getSnipeData() {
            return this.snipeData;
        }

        public Message getMessageHelper() {
            return this.messageHelper;
        }

        public IBrush getCurrentBrush() {
            if (this.currentBrush == null) {
                return null;
            }
            return this.brushes.getInstance(this.currentBrush);
        }

        public IBrush setCurrentBrush(Class<? extends IBrush> brush) {
            Preconditions.checkNotNull(brush, "Can't set brush to null.");
            IBrush brushInstance = (IBrush)this.brushes.get(brush);
            if (brushInstance == null) {
                brushInstance = this.instanciateBrush(brush);
                Preconditions.checkNotNull(brushInstance, "Could not instanciate brush class.");
                if (this.snipeData.owner().getPlayer().hasPermission(brushInstance.getPermissionNode())) {
                    this.brushes.put(brush, brushInstance);
                    this.previousBrush = this.currentBrush;
                    this.currentBrush = brush;
                    return brushInstance;
                }
            }
            if (this.snipeData.owner().getPlayer().hasPermission(brushInstance.getPermissionNode())) {
                this.previousBrush = this.currentBrush;
                this.currentBrush = brush;
                return brushInstance;
            }
            return null;
        }

        public IBrush previousBrush() {
            if (this.previousBrush == null) {
                return null;
            }
            return this.setCurrentBrush(this.previousBrush);
        }

        private IBrush instanciateBrush(Class<? extends IBrush> brush) {
            try {
                return brush.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }
}

