/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import java.util.Set;
import org.bukkit.Art;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;

public final class PaintingWrapper {
    private PaintingWrapper() {
    }

    public static void paint(Player p, boolean auto, boolean back, int choice) {
        Location targetLocation = p.getTargetBlock((Set)null, 4).getLocation();
        Chunk paintingChunk = p.getTargetBlock((Set)null, 4).getLocation().getChunk();
        Double bestDistanceMatch = 50.0;
        Painting bestMatch = null;
        for (Entity entity : paintingChunk.getEntities()) {
            Double distance;
            if (entity.getType() != EntityType.PAINTING || !((distance = Double.valueOf(targetLocation.distanceSquared(entity.getLocation()))) <= 4.0) || !(distance < bestDistanceMatch)) continue;
            bestDistanceMatch = distance;
            bestMatch = (Painting)entity;
        }
        if (bestMatch != null) {
            if (auto) {
                try {
                    int i = bestMatch.getArt().getId() + (back ? -1 : 1) + Art.values().length % Art.values().length;
                    Art art = Art.getById((int)i);
                    if (art == null) {
                        p.sendMessage(ChatColor.RED + "This is the final painting, try scrolling to the other direction.");
                        return;
                    }
                    bestMatch.setArt(art);
                    p.sendMessage(ChatColor.GREEN + "Painting set to ID: " + i);
                }
                catch (Exception e) {
                    p.sendMessage(ChatColor.RED + "Oops. Something went wrong.");
                }
            } else {
                try {
                    Art art = Art.getById((int)choice);
                    bestMatch.setArt(art);
                    p.sendMessage(ChatColor.GREEN + "Painting set to ID: " + choice);
                }
                catch (Exception exception) {
                    p.sendMessage(ChatColor.RED + "Your input was invalid somewhere.");
                }
            }
        }
    }
}

