/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.SnipeData;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class Message {
    private static final int BRUSH_SIZE_WARNING_THRESHOLD = 20;
    private final SnipeData snipeData;

    public Message(SnipeData snipeData) {
        this.snipeData = snipeData;
    }

    public void brushMessage(String brushMessage) {
        this.snipeData.sendMessage(ChatColor.LIGHT_PURPLE + brushMessage);
    }

    public void brushName(String brushName) {
        this.snipeData.sendMessage(ChatColor.AQUA + "Brush Type: " + ChatColor.LIGHT_PURPLE + brushName);
    }

    public void center() {
        this.snipeData.sendMessage(ChatColor.DARK_BLUE + "Brush Center: " + ChatColor.DARK_RED + this.snipeData.getcCen());
    }

    public void custom(String message) {
        this.snipeData.sendMessage(message);
    }

    public void data() {
        this.snipeData.sendMessage(ChatColor.BLUE + "Data Variable: " + ChatColor.DARK_RED + this.snipeData.getData());
    }

    public void height() {
        this.snipeData.sendMessage(ChatColor.DARK_AQUA + "Brush Height: " + ChatColor.DARK_RED + this.snipeData.getVoxelHeight());
    }

    public void performerName(String performerName) {
        this.snipeData.sendMessage(ChatColor.DARK_PURPLE + "Performer: " + ChatColor.DARK_GREEN + performerName);
    }

    public void replace() {
        this.snipeData.sendMessage(ChatColor.AQUA + "Replace Material: " + ChatColor.RED + this.snipeData.getReplaceId() + ChatColor.GRAY + " (" + Material.getMaterial((int)this.snipeData.getReplaceId()).toString() + ")");
    }

    public void replaceData() {
        this.snipeData.sendMessage(ChatColor.DARK_GRAY + "Replace Data Variable: " + ChatColor.DARK_RED + this.snipeData.getReplaceData());
    }

    public void size() {
        this.snipeData.sendMessage(ChatColor.GREEN + "Brush Size: " + ChatColor.DARK_RED + this.snipeData.getBrushSize());
        if (this.snipeData.getBrushSize() >= 20) {
            this.snipeData.sendMessage(ChatColor.RED + "WARNING: Large brush size selected!");
        }
    }

    public void toggleLightning() {
        this.snipeData.sendMessage(ChatColor.GOLD + "Lightning mode has been toggled " + ChatColor.DARK_RED + (this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isLightningEnabled() ? "on" : "off"));
    }

    public final void togglePrintout() {
        this.snipeData.sendMessage(ChatColor.GOLD + "Brush info printout mode has been toggled " + ChatColor.DARK_RED + (this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isLightningEnabled() ? "on" : "off"));
    }

    public void toggleRange() {
        this.snipeData.sendMessage(ChatColor.GOLD + "Distance Restriction toggled " + ChatColor.DARK_RED + (this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).isRanged() ? "on" : "off") + ChatColor.GOLD + ". Range is " + ChatColor.LIGHT_PURPLE + (double)this.snipeData.owner().getSnipeData(this.snipeData.owner().getCurrentToolId()).getRange());
    }

    public void voxel() {
        this.snipeData.sendMessage(ChatColor.GOLD + "Voxel: " + ChatColor.RED + this.snipeData.getVoxelId() + ChatColor.GRAY + " (" + Material.getMaterial((int)this.snipeData.getVoxelId()).toString() + ")");
    }

    public void voxelList() {
        if (this.snipeData.getVoxelList().isEmpty()) {
            this.snipeData.sendMessage(ChatColor.DARK_GREEN + "No blocks selected!");
        } else {
            StringBuilder returnValueBuilder = new StringBuilder();
            returnValueBuilder.append(ChatColor.DARK_GREEN);
            returnValueBuilder.append("Block Types Selected: ");
            returnValueBuilder.append(ChatColor.AQUA);
            for (int[] valuePair : this.snipeData.getVoxelList().getList()) {
                returnValueBuilder.append(valuePair[0]);
                if (valuePair[1] != -1) {
                    returnValueBuilder.append(":");
                    returnValueBuilder.append(valuePair[1]);
                }
                returnValueBuilder.append(" ");
            }
            this.snipeData.sendMessage(returnValueBuilder.toString());
        }
    }
}

