/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.pos;

import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.lib.gui.pos.PositionAdded;
import buildcraft.lib.gui.pos.PositionCallable;
import buildcraft.lib.gui.pos.PositionOffset;
import java.util.function.DoubleSupplier;

public interface IGuiPosition {
    public double getX();

    public double getY();

    default public IGuiPosition offset(DoubleSupplier x, DoubleSupplier y) {
        if (x instanceof IConstantNode && y instanceof IConstantNode) {
            return this.offset(x.getAsDouble(), y.getAsDouble());
        }
        return this.offset(new PositionCallable(x, y));
    }

    default public IGuiPosition offset(double x, DoubleSupplier y) {
        if (y instanceof IConstantNode) {
            return this.offset(x, y.getAsDouble());
        }
        return this.offset(new PositionCallable(x, y));
    }

    default public IGuiPosition offset(DoubleSupplier x, double y) {
        if (x instanceof IConstantNode) {
            return this.offset(x.getAsDouble(), y);
        }
        return this.offset(new PositionCallable(x, y));
    }

    default public IGuiPosition offset(double x, double y) {
        return PositionOffset.createOffset(this, x, y);
    }

    default public IGuiPosition offset(IGuiPosition by) {
        return new PositionAdded(this, by);
    }

    public static IGuiPosition create(DoubleSupplier x, DoubleSupplier y) {
        if (x instanceof IConstantNode && y instanceof IConstantNode) {
            return new PositionAbsolute(x.getAsDouble(), y.getAsDouble());
        }
        return new PositionCallable(x, y);
    }
}

