/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xreliquary.init.ModItems;

public class FluidHandlerEmperorChalice
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack chalice;

    public FluidHandlerEmperorChalice(ItemStack chalice) {
        this.chalice = chalice;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, 1000), 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!ModItems.emperorChalice.isEnabled(this.chalice) || resource == null || resource.amount <= 0 || resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        return resource.amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (ModItems.emperorChalice.isEnabled(this.chalice) || resource == null || resource.amount <= 0 || resource.getFluid() != FluidRegistry.WATER) {
            return new FluidStack(FluidRegistry.WATER, 0);
        }
        return new FluidStack(FluidRegistry.WATER, Math.min(resource.amount, 1000));
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (ModItems.emperorChalice.isEnabled(this.chalice)) {
            return new FluidStack(FluidRegistry.WATER, 0);
        }
        return new FluidStack(FluidRegistry.WATER, Math.min(maxDrain, 1000));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.chalice;
    }
}

