/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.Collector;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.GaugeMetricFamily;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.Histogram;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;

public class MinecraftCollector
extends Collector
implements Collector.Describable {
    private static final double[] TICK_BUCKETS = new double[]{0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0};
    @Nullable
    private Integer dim_tick_id;
    private final Histogram dim_tick_seconds;
    @Nullable
    private Histogram.Timer dim_tick_timer;
    private final MinecraftServer mc_server;
    private final Histogram server_tick_seconds;
    @Nullable
    private Histogram.Timer server_tick_timer;

    public MinecraftCollector(MinecraftServer mc_server) {
        this.mc_server = mc_server;
        this.server_tick_seconds = ((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(TICK_BUCKETS).name("mc_server_tick_seconds")).help("Stats on server tick times.")).create();
        this.dim_tick_seconds = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(TICK_BUCKETS).name("mc_dimension_tick_seconds")).labelNames("id", "name")).help("Stats on dimension tick times.")).create();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily player_list = this.collectPlayerList();
        List<Collector.MetricFamilySamples> server_ticks = this.server_tick_seconds.collect();
        GaugeMetricFamily dim_chunks_loaded = this.collectDimensionChunksLoaded();
        List<Collector.MetricFamilySamples> dim_ticks = this.dim_tick_seconds.collect();
        ArrayList<Collector.MetricFamilySamples> metrics = new ArrayList<Collector.MetricFamilySamples>(1 + server_ticks.size() + 1 + dim_ticks.size());
        metrics.add(player_list);
        metrics.addAll(server_ticks);
        metrics.add(dim_chunks_loaded);
        metrics.addAll(dim_ticks);
        return metrics;
    }

    private GaugeMetricFamily collectDimensionChunksLoaded() {
        GaugeMetricFamily metric = MinecraftCollector.newDimensionChunksLoadedMetric();
        for (WorldServer world : this.mc_server.field_71305_c) {
            DimensionType dim = world.field_73011_w.func_186058_p();
            String id_str = Integer.toString(dim.func_186068_a());
            String name = dim.func_186065_b();
            int loaded = world.func_72863_F().func_73152_e();
            metric.addMetric(Arrays.asList(id_str, name), loaded);
        }
        return metric;
    }

    private GaugeMetricFamily collectPlayerList() {
        GaugeMetricFamily metric = MinecraftCollector.newPlayerListMetric();
        for (EntityPlayerMP player : this.mc_server.func_184103_al().func_181057_v()) {
            GameProfile profile = player.func_146103_bH();
            String id_str = profile.getId().toString();
            String name = profile.getName();
            metric.addMetric(Arrays.asList(id_str, name), 1.0);
        }
        return metric;
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> descs = new ArrayList<Collector.MetricFamilySamples>();
        descs.add(MinecraftCollector.newPlayerListMetric());
        descs.addAll(this.server_tick_seconds.describe());
        descs.add(MinecraftCollector.newDimensionChunksLoadedMetric());
        descs.addAll(this.dim_tick_seconds.describe());
        return descs;
    }

    private static GaugeMetricFamily newDimensionChunksLoadedMetric() {
        return new GaugeMetricFamily("mc_dimension_chunks_loaded", "The number of loaded dimension chunks.", Arrays.asList("id", "name"));
    }

    private static GaugeMetricFamily newPlayerListMetric() {
        return new GaugeMetricFamily("mc_player_list", "The players connected to the server.", Arrays.asList("id", "name"));
    }

    public void startDimensionTick(DimensionType dim) {
        int id = dim.func_186068_a();
        if (this.dim_tick_timer != null) {
            throw new IllegalStateException("Dimension " + id + " tick started before stopping previous tick for dimension " + this.dim_tick_id + ".");
        }
        String id_str = Integer.toString(id);
        String name = dim.func_186065_b();
        this.dim_tick_id = id;
        this.dim_tick_timer = ((Histogram.Child)this.dim_tick_seconds.labels(id_str, name)).startTimer();
    }

    public void startServerTick() {
        if (this.server_tick_timer != null) {
            throw new IllegalStateException("Server tick started before stopping previous tick.");
        }
        this.server_tick_timer = this.server_tick_seconds.startTimer();
    }

    public void stopDimensionTick(DimensionType dim) {
        int id = dim.func_186068_a();
        if (this.dim_tick_timer == null) {
            throw new IllegalStateException("Dimension " + id + " tick stopped without an active tick.");
        }
        if (this.dim_tick_id != null && this.dim_tick_id != id) {
            throw new IllegalStateException("Dimension " + id + " tick stopped while in an active tick for dimension " + this.dim_tick_id + ".");
        }
        this.dim_tick_timer.observeDuration();
        this.dim_tick_timer = null;
        this.dim_tick_id = null;
    }

    public void stopServerTick() {
        if (this.server_tick_timer == null) {
            throw new IllegalStateException("Server tick stopped without an active tick.");
        }
        this.server_tick_timer.observeDuration();
        this.server_tick_timer = null;
    }
}

