/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.configuration.ProfileList;
import technicianlp.reauth.crypto.Crypto;

public final class Config {
    private final Configuration config;
    private final ProfileList profileList;

    public Config(Path configFile) {
        Crypto.updateConfigPath(this.getPath(configFile));
        this.config = new Configuration(configFile.toFile());
        this.profileList = new ProfileList(this);
    }

    public final void loadConfig() {
        ConfigCategory profiles = this.config.getCategory("profiles");
        profiles.setComment("Saved Profiles. Check Documentation for Info & Syntax");
        this.profileList.loadConfig(profiles);
        if (this.config.hasCategory("general")) {
            ConfigCategory general = this.config.getCategory("general");
            general.remove((Object)"offlineModeEnabled");
            general.remove((Object)"password");
            general.remove((Object)"username");
            general.remove((Object)"validatorBold");
            general.remove((Object)"validatorEnabled");
            if (general.isEmpty()) {
                this.config.removeCategory(general);
            }
        }
        this.save();
    }

    public final void save() {
        this.config.save();
    }

    public final ProfileList getProfileList() {
        return this.profileList;
    }

    private String getPath(Path config) {
        if (Files.exists(config, new LinkOption[0])) {
            try {
                return config.toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException e) {
                ReAuth.log.error("Could not resolve real path", (Throwable)e);
            }
        }
        return config.toString();
    }

    final Configuration getConfig() {
        return this.config;
    }
}

