/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.helper.ToolHelpers;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LeafBlowerModule
extends PowerModuleBase
implements IRightClickModule {
    public LeafBlowerModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), new ItemStack(Items.field_151042_j, 3));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBasePropertyDouble("energyCon", 500.0, "RF");
        this.addTradeoffPropertyDouble("radius", "energyCon", 9500.0);
        this.addBasePropertyDouble("radius", 1.0, "m");
        this.addTradeoffPropertyDouble("radius", "radius", 15.0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "leafBlower";
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        int radius = (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "radius");
        if (this.useBlower(radius, itemStackIn, playerIn, worldIn, playerIn.func_180425_c())) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack itemStack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    private boolean useBlower(int radius, ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
        int totalEnergyDrain = 0;
        for (int i = pos.func_177958_n() - radius; i < pos.func_177958_n() + radius; ++i) {
            for (int j = pos.func_177956_o() - radius; j < pos.func_177956_o() + radius; ++j) {
                for (int k = pos.func_177952_p() - radius; k < pos.func_177952_p() + radius; ++k) {
                    BlockPos newPos = new BlockPos(i, j, k);
                    if (!ToolHelpers.blockCheckAndHarvest((EntityPlayer)player, (World)world, (BlockPos)newPos)) continue;
                    totalEnergyDrain += this.getEnergyUsage(itemStack);
                }
            }
        }
        ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, (int)totalEnergyDrain);
        return true;
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "energyCon");
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.leafBlower;
    }
}

